/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.ws.rs.CookieParam;
import javax.ws.rs.core.Cookie;
import org.jboss.resteasy.core.StringParameterInjector;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class CookieParamInjector
extends StringParameterInjector
implements ValueInjector {
    public CookieParamInjector(Class type, Type genericType, AccessibleObject target, String cookieName, String defaultValue, Annotation[] annotations, ResteasyProviderFactory factory) {
        if (type.equals(Cookie.class)) {
            this.type = type;
            this.paramName = cookieName;
            this.paramType = CookieParam.class;
            this.defaultValue = defaultValue;
        } else {
            this.initialize(type, genericType, cookieName, CookieParam.class, defaultValue, target, annotations, factory);
        }
    }

    @Override
    public CompletionStage<Object> inject(HttpRequest request, HttpResponse response, boolean unwrapAsync) {
        Cookie cookie = (Cookie)request.getHttpHeaders().getCookies().get(this.paramName);
        if (this.type.equals(Cookie.class)) {
            return CompletableFuture.completedFuture(cookie);
        }
        if (cookie == null) {
            return CompletableFuture.completedFuture(this.extractValues(null));
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(cookie.getValue());
        return CompletableFuture.completedFuture(this.extractValues(values));
    }

    @Override
    public CompletionStage<Object> inject(boolean unwrapAsync) {
        throw new RuntimeException(Messages.MESSAGES.illegalToInjectCookieParam());
    }
}

