/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ws.rs.WebApplicationException;
import org.jboss.resteasy.core.MessageBodyParameterInjector;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.BadRequestException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.metadata.MethodParameter;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.validation.GeneralValidator;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;

public class MethodInjectorImpl
implements MethodInjector {
    protected ValueInjector[] params;
    protected ResteasyProviderFactory factory;
    protected ResourceLocator method;
    protected Method interfaceBasedMethod;
    protected boolean expectsBody;

    public MethodInjectorImpl(ResourceLocator resourceMethod, ResteasyProviderFactory factory) {
        this.factory = factory;
        this.method = resourceMethod;
        this.interfaceBasedMethod = MethodInjectorImpl.findInterfaceBasedMethod(resourceMethod.getResourceClass().getClazz(), resourceMethod.getMethod());
        this.params = new ValueInjector[resourceMethod.getParams().length];
        int i = 0;
        for (MethodParameter parameter : resourceMethod.getParams()) {
            this.params[i] = factory.getInjectorFactory().createParameterExtractor(parameter, factory);
            if (this.params[i] instanceof MessageBodyParameterInjector) {
                this.expectsBody = true;
            }
            ++i;
        }
    }

    @Override
    public boolean expectsBody() {
        return this.expectsBody;
    }

    public static Method findInterfaceBasedMethod(Class root, Method method) {
        if (method.getDeclaringClass().isInterface() || root.isInterface()) {
            return method;
        }
        for (Class<?> intf : root.getInterfaces()) {
            try {
                return intf.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException ignored) {
            }
        }
        if (root.getSuperclass() == null || root.getSuperclass().equals(Object.class)) {
            return method;
        }
        return MethodInjectorImpl.findInterfaceBasedMethod(root.getSuperclass(), method);
    }

    @Override
    public ValueInjector[] getParams() {
        return this.params;
    }

    @Override
    public Object[] injectArguments(HttpRequest input, HttpResponse response) {
        try {
            Object[] args = null;
            if (this.params != null && this.params.length > 0) {
                args = new Object[this.params.length];
                int i = 0;
                for (ValueInjector extractor : this.params) {
                    args[i++] = extractor.inject(input, response);
                }
            }
            return args;
        }
        catch (WebApplicationException we) {
            throw we;
        }
        catch (Failure f) {
            throw f;
        }
        catch (Exception e) {
            BadRequestException badRequest = new BadRequestException("Failed processing arguments of " + this.method.toString(), e);
            badRequest.setLoggable(true);
            throw badRequest;
        }
    }

    @Override
    public Object invoke(HttpRequest request, HttpResponse httpResponse, Object resource) throws Failure, ApplicationException {
        Method invokedMethod;
        Object[] args = this.injectArguments(request, httpResponse);
        GeneralValidator validator = (GeneralValidator)GeneralValidator.class.cast(request.getAttribute(GeneralValidator.class.getName()));
        if (validator != null) {
            validator.validateAllParameters(request, resource, this.method.getMethod(), args, new Class[0]);
        }
        if (!(invokedMethod = this.method.getMethod()).getDeclaringClass().isAssignableFrom(resource.getClass())) {
            invokedMethod = this.interfaceBasedMethod;
        }
        Object result = null;
        try {
            result = invokedMethod.invoke(resource, args);
        }
        catch (IllegalAccessException e) {
            throw new InternalServerErrorException("Not allowed to reflect on method: " + this.method.toString(), e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (validator instanceof GeneralValidatorCDI) {
                ((GeneralValidatorCDI)GeneralValidatorCDI.class.cast(validator)).checkForConstraintViolations(request, e);
            }
            throw new ApplicationException(cause);
        }
        catch (IllegalArgumentException e) {
            String msg = "Bad arguments passed to " + this.method.toString() + "  (";
            if (args != null) {
                boolean first = false;
                for (Object arg : args) {
                    if (!first) {
                        first = true;
                    } else {
                        msg = msg + ",";
                    }
                    msg = arg == null ? msg + " null" : msg + " " + arg.getClass().getName() + " " + arg;
                }
            }
            msg = msg + " )";
            throw new InternalServerErrorException(msg, e);
        }
        if (validator != null) {
            validator.validateReturnValue(request, resource, this.method.getMethod(), result, new Class[0]);
        }
        return result;
    }
}

