/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;
import org.jboss.naming.ThreadLocalStack;
import org.jboss.util.collection.ConcurrentReferenceHashMap;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;
import org.jnp.server.NamingServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ENCFactory
implements ObjectFactory {
    private static ConcurrentReferenceHashMap<ClassLoader, Context> classloaderKeyedEncs = new ConcurrentReferenceHashMap(16, 0.75f, 4, ConcurrentReferenceHashMap.ReferenceType.WEAK, ConcurrentReferenceHashMap.ReferenceType.STRONG, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
    private static ClassLoader topLoader;
    private static ThreadLocalStack<Object> encIdStack;
    private static ConcurrentHashMap<Object, Context> encById;

    public static List<Object> getIdStack() {
        return encIdStack.getList();
    }

    public static ConcurrentHashMap<Object, Context> getEncById() {
        return encById;
    }

    public static void pushContextId(Object id) {
        encIdStack.push(id);
    }

    public static Object popContextId() {
        return encIdStack.pop();
    }

    public static Object getCurrentId() {
        return encIdStack.get();
    }

    public static void setTopClassLoader(ClassLoader topLoader) {
        ENCFactory.topLoader = topLoader;
    }

    public static ClassLoader getTopClassLoader() {
        return topLoader;
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Object currentId = encIdStack.get();
        if (currentId != null) {
            Context compCtx = encById.get(currentId);
            if (compCtx == null) {
                compCtx = this.createContext(environment);
                encById.put(currentId, compCtx);
            }
            return compCtx;
        }
        ClassLoader ctxClassLoader = GetTCLAction.getContextClassLoader();
        Context compCtx = (Context)classloaderKeyedEncs.get((Object)ctxClassLoader);
        if (compCtx == null) {
            Context old;
            ClassLoader loader = ctxClassLoader;
            GetParentAction action = new GetParentAction(ctxClassLoader);
            while (loader != null && loader != topLoader && compCtx == null) {
                compCtx = (Context)classloaderKeyedEncs.get((Object)loader);
                loader = action.getParent();
            }
            if (compCtx == null && (old = (Context)classloaderKeyedEncs.putIfAbsent((Object)ctxClassLoader, (Object)(compCtx = this.createContext(environment)))) != null) {
                compCtx = old;
            }
        }
        return compCtx;
    }

    protected NamingServer createServer() throws NamingException {
        return new NamingServer();
    }

    protected Context createContext(Hashtable environment) throws NamingException {
        NamingServer srv = this.createServer();
        return new NamingContext(environment, null, (Naming)srv);
    }

    static {
        encIdStack = new ThreadLocalStack();
        encById = new ConcurrentHashMap();
    }

    private static class GetParentAction
    implements PrivilegedAction {
        ClassLoader loader;

        GetParentAction(ClassLoader loader) {
            this.loader = loader;
        }

        public Object run() {
            ClassLoader parent = null;
            if (this.loader != null) {
                this.loader = parent = this.loader.getParent();
            }
            return parent;
        }

        ClassLoader getParent() {
            return (ClassLoader)AccessController.doPrivileged(this);
        }
    }

    private static class GetTCLAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetTCLAction();

        private GetTCLAction() {
        }

        public Object run() {
            return Thread.currentThread().getContextClassLoader();
        }

        static ClassLoader getContextClassLoader() {
            return (ClassLoader)AccessController.doPrivileged(ACTION);
        }
    }
}

