package org.jboss.jsr299.tck.tests.xml.namespace.javaee;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.tests.xml.namespace.javaee.foo.AnotherDeploymentType;
import org.jboss.jsr299.tck.tests.xml.namespace.javaee.foo.Order;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

@Artifact
@Resources({
   @Resource(source="namespace", destination="WEB-INF/classes/org/jboss/jsr299/tck/tests/xml/namespace/javaee/namespace")
})
@Classes({Order.class, AnotherDeploymentType.class})
@BeansXml("beans.xml")
public class JavaEeNamespaceTest extends AbstractJSR299Test
{
   @Test
   @SpecAssertions({
	  @SpecAssertion(section="9.1", id="e"),
	  @SpecAssertion(section="9.1", id="f"),
	  @SpecAssertion(section="9.2", id="f"),
     @SpecAssertion(section="9.2.1", id="b"),
     @SpecAssertion(section="9.2.1", id="c"),
     @SpecAssertion(section="9.2.1", id="d"),
     @SpecAssertion(section="9.2.1", id="e")
   })
   public void testJavaEeNamespace()
   {
      assert getCurrentManager().resolveByType(Order.class).size() == 1;
   }
}
