package org.jboss.jsr299.tck.tests.xml.annotationtypes;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.tests.xml.annotationtypes.foo.AnotherTestInterceptorBindingType;
import org.jboss.jsr299.tck.tests.xml.annotationtypes.foo.TestBindingType;
import org.jboss.jsr299.tck.tests.xml.annotationtypes.foo.TestDeploymentType;
import org.jboss.jsr299.tck.tests.xml.annotationtypes.foo.TestInterceptorBindingType;
import org.jboss.jsr299.tck.tests.xml.annotationtypes.foo.TestNamed;
import org.jboss.jsr299.tck.tests.xml.annotationtypes.foo.TestScopeType;
import org.jboss.jsr299.tck.tests.xml.annotationtypes.foo.TestStereotype;
import org.jboss.jsr299.tck.tests.xml.annotationtypes.foo.Order;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

@Artifact
@Classes({
   Order.class,
   TestBindingType.class, 
   TestInterceptorBindingType.class, 
   TestStereotype.class, 
   AnotherTestInterceptorBindingType.class, 
   TestScopeType.class,
   TestDeploymentType.class,
   TestNamed.class})
@BeansXml("beans.xml")
public class AnnotationTypesTest extends AbstractJSR299Test
{
   @Test
   @SpecAssertions({
      @SpecAssertion(section="9", id="d"),//without schema
      @SpecAssertion(section="9.4", id="a"),
      @SpecAssertion(section="9.4", id="b"),
      @SpecAssertion(section="9.4", id="c"),
      @SpecAssertion(section="9.4", id="e"),
      @SpecAssertion(section="9.4", id="f"),
      @SpecAssertion(section="9.4", id="g"),
      @SpecAssertion(section="9.4.1", id="a"),
      @SpecAssertion(section="9.4.1", id="d"),
      @SpecAssertion(section="9.4.1", id="e"),
      @SpecAssertion(section="9.4.1", id="f"),
      @SpecAssertion(section="9.4.1", id="g"),
      @SpecAssertion(section="9.4.2", id="a"),
      @SpecAssertion(section="9.4.2", id="d")
   })
   public void testAnnotationTypes()
   {
      assert getCurrentManager().resolveByType(Order.class).size() == 1;
   }
}
