package org.jboss.jsr299.tck.tests.lookup.nonContextual.servlet;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.war.WarArtifactDescriptor;
import org.testng.annotations.Test;

@Artifact
@IntegrationTest(runLocally=true)
@Resources({
   @Resource(destination=WarArtifactDescriptor.WEB_XML_DESTINATION, source="web.xml")
})
public class InjectionIntoServletTest extends AbstractJSR299Test
{
   
   @Test(groups = { "ri-broken", "integration" })
   @SpecAssertion(section = "5.12.3", id = "a")
   public void testInjectionIntoServlet() throws Exception
   {
      HttpClient client = new HttpClient();
      HttpMethod method = new GetMethod(getContextPath());
      assert client.executeMethod(method) == 200;
   }
   
}
