package org.jboss.jsr299.tck.tests.lookup.manager;

import javax.context.Dependent;
import javax.inject.Current;
import javax.inject.Standard;
import javax.inject.manager.Bean;
import javax.inject.manager.Manager;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
public class ManagerTest extends AbstractJSR299Test
{
   @Test(groups={"manager", "injection", "deployment"}) 
   @SpecAssertion(section="5.7.2", id = "a")
   public void testInjectingManager() throws Exception
   {
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            FishFarmOffice fishFarmOffice = getCurrentManager().getInstanceByType(FishFarmOffice.class);
            assert fishFarmOffice.manager != null;
         }
         
      }.run();      
   }  
   
   @Test
   @SpecAssertion(section = "5.7.2", id = "aa")
   public void testContainerProvidesManagerBean()
   {
      assert getCurrentManager().resolveByType(Manager.class).size() > 0;
   }
   
   @Test
   @SpecAssertion(section = "5.7.2", id = "ab")
   public void testManagerBeanIsDependentScoped()
   {
      Bean<Manager> manager = getCurrentManager().resolveByType(Manager.class).iterator().next();
      assert manager.getScopeType().equals(Dependent.class);
   }
   
   @Test
   @SpecAssertion(section = "5.7.2", id = "ac")   
   public void testManagerBeanHasStandardDeployment()
   {
      Bean<Manager> manager = getCurrentManager().resolveByType(Manager.class).iterator().next();      
      assert manager.getDeploymentType().equals(Standard.class);
   }

   @Test
   @SpecAssertion(section = "5.7.2", id = "ad")
   public void testManagerBeanHasCurrentBinding()
   {      
      Bean<Manager> manager = getCurrentManager().resolveByType(Manager.class).iterator().next();
      assert manager.getBindings().iterator().next() instanceof Current;
   }
   
   @Test
   @SpecAssertions({
      @SpecAssertion(section = "5.7.2", id = "c"),
      @SpecAssertion(section = "5.7.2", id = "d")
   })
   public void testGetInstanceReturnsContextualInstance()
   {
      Bean<FishFarmOffice> bean = getCurrentManager().resolveByType(FishFarmOffice.class).iterator().next();
      assert getCurrentManager().getInstance(bean) instanceof FishFarmOffice;      
   }
}
