package org.jboss.jsr299.tck.tests.lookup.injection;

import javax.context.ContextNotActiveException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
@BeansXml("beans.xml")
public class InjectionTest extends AbstractJSR299Test
{

   @Test(groups = { "injection", "producerMethod" })
   @SpecAssertion(section = "5.2", id = "aa")
   public void testInjectionPerformsBoxingIfNecessary() throws Exception
   {
      assert getCurrentManager().resolveByType(SpiderNest.class).size() == 1;
      SpiderNest spiderNest = getCurrentManager().getInstanceByType(SpiderNest.class);
      assert spiderNest.numberOfSpiders != null;
      assert spiderNest.numberOfSpiders.equals(4);
   }

   @Test(groups = { "injection", "clientProxy" }, expectedExceptions = ContextNotActiveException.class)
   @SpecAssertion(section = "5.3", id = "a")
   public void testInvokeNormalInjectedWebBeanWhenContextNotActive()
   {
      assert getCurrentManager().resolveByType(TunaFarm.class).size() == 1;
      TunaFarm tunaFarm = getCurrentManager().getInstanceByType(TunaFarm.class);
      assert tunaFarm.tuna != null;
      getCurrentConfiguration().getContexts().setInactive(getCurrentConfiguration().getContexts().getRequestContext());
      tunaFarm.tuna.getName();
   }

   @Test(groups = "injection")
   @SpecAssertion(section = "5.3", id = "b")
   public void testInvokeDependentScopeWhenContextNotActive()
   {
      assert getCurrentManager().resolveByType(FoxRun.class).size() == 1;
      FoxRun foxRun = getCurrentManager().getInstanceByType(FoxRun.class);
      assert foxRun.fox.getName().equals("gavin");
   }
   
   @Test 
   @SpecAssertion(section="4.2", id = "aa")
   public void testFieldDeclaredInSuperclassInjected() throws Exception
   {      
      new RunInDependentContext()
      {
        @Override
         protected void execute() throws Exception
         {
           DeluxeHenHouse henHouse = getCurrentManager().getInstanceByType(DeluxeHenHouse.class);
           assert henHouse.fox != null;
           assert henHouse.fox.getName().equals("gavin");
         }
      }.run();
   }
   
   @Test 
   @SpecAssertion(section="4.2", id = "ac")
   public void testFieldDeclaredInIndirectSuperclassInjected() throws Exception
   {      
      new RunInDependentContext()
      {
        @Override
         protected void execute() throws Exception
         {
           MegaPoorHenHouse henHouse = getCurrentManager().getInstanceByType(MegaPoorHenHouse.class);
           assert henHouse.fox != null;
           assert henHouse.fox.getName().equals("gavin");
         }
      }.run();
   }

   @Test(groups = {"injection", "underInvestigation"})
   @SpecAssertion(section = "3.8", id = "aa")
   public void testInjectingStaticField()
   {
      assert getCurrentManager().resolveByType(BeanWithStaticBoundField_Broken.class).size() == 1;
      assert getCurrentManager().getInstanceByType(BeanWithStaticBoundField_Broken.class).tuna == null;
   }

   @Test(groups = {"injection", "underInvestigation"})
   @SpecAssertion(section = "3.8", id = "ab")
   public void testInjectingFinalField()
   {
      assert getCurrentManager().resolveByType(BeanWithFinalBoundField_Broken.class).size() == 1;
      assert getCurrentManager().getInstanceByType(BeanWithFinalBoundField_Broken.class).tuna == null;
   }

}
