package org.jboss.jsr299.tck.tests.lookup.el;

import javax.context.Context;
import javax.context.Conversation;
import javax.context.RequestScoped;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
public class ResolutionByNameTest extends AbstractJSR299Test
{
   
   @Test(groups={"stub", "el"})  @SpecAssertion(section="5.10", id = "ab")
   public void testELResolverRegisteredWithJsf()
   {
      assert false;
   }
   
   @Test(groups={"stub", "el"})  @SpecAssertion(section="5.10", id = "aa")
   public void testELResolverRegisteredWithServlet()
   {
      assert false;
   }
   
   @Test
   @SpecAssertion(section="5.10", id="c")
   public void testQualifiedNameLookup()
   {
      assert getCurrentConfiguration().getEl().evaluateValueExpression("#{javax.context.conversation}", Conversation.class) != null;
      assert getCurrentConfiguration().getEl().evaluateValueExpression("#{javax.context.conversation}", Conversation.class) instanceof Conversation;
   }

   @Test(groups = "beanLifecycle")
   @SpecAssertions({
      @SpecAssertion(section = "6", id = "h")
   })
   public void testContextCreatesNewInstanceForInjection()
   {
      Context requestContext = getCurrentManager().getContext(RequestScoped.class);
      Bean<Tuna> tunaBean = getCurrentManager().resolveByType(Tuna.class).iterator().next();
      assert requestContext.get(tunaBean) == null;
      TunaFarm tunaFarm = getCurrentConfiguration().getEl().evaluateValueExpression("#{tunaFarm}", TunaFarm.class);
      assert tunaFarm.tuna != null;
   }

}
