package org.jboss.jsr299.tck.tests.lookup.dependency.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;

import javax.context.RequestScoped;
import javax.inject.UnproxyableDependencyException;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;
import javax.inject.manager.InjectionPoint;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.ForwardingBean;
import org.jboss.jsr299.tck.literals.CurrentLiteral;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class DependencyResolutionTest extends AbstractJSR299Test
{
   class MockInjectionPoint implements InjectionPoint
   {
      private Bean<?> bean;
      private Type type;
      private Member member;
      private Set<Annotation> bindings;
      
      public MockInjectionPoint(Bean<?> bean, Type type, Member member, 
            Set<Annotation> bindings)
      {
         this.bean = bean;
         this.type = type;
         this.member = member;
         this.bindings = bindings;
      }
      
      public <T extends Annotation> T getAnnotation(Class<T> arg0)
      {
         return null;
      }

      public Annotation[] getAnnotations()
      {
         return null;
      }

      public Bean<?> getBean()
      {
         return bean;
      }

      public Set<Annotation> getBindings()
      {
         return bindings;
      }

      public Member getMember()
      {
         return member;
      }

      public Type getType()
      {
         return type;
      }

      public boolean isAnnotationPresent(Class<? extends Annotation> arg0)
      {
         return false;
      }      
   }
   
   @Test
   @SpecAssertions({
      @SpecAssertion(section = "5.7.1", id = "c"),
      @SpecAssertion(section = "5.7.1", id = "d")
   })
   public void testGetInstanceToInjectReturnsContextualInstance() throws Exception
   {
      Bean<Vanilla> vanillaBean = getCurrentManager().resolveByType(Vanilla.class).iterator().next();
      
      Field injectedField = InjectedBean.class.getField("vanilla");
      Set<Annotation> bindings = new HashSet<Annotation>();
      bindings.add(new CurrentLiteral());
      MockInjectionPoint injectionPoint = new MockInjectionPoint(vanillaBean, Vanilla.class, injectedField, bindings);
      
      assert getCurrentManager().getInstanceToInject(injectionPoint) instanceof Vanilla;
   }
   
   @Test(expectedExceptions = UnsatisfiedDependencyException.class)
   @SpecAssertion(section = "5.7.1", id = "e")
   public void testGetInstanceToInjectThrowsUnsatisfiedDependencyException() throws Exception
   {
      Bean<Vanilla> vanillaBean = getCurrentManager().resolveByType(Vanilla.class).iterator().next();
      
      Field injectedField = InjectedBean.class.getField("vanilla");
      Set<Annotation> bindings = new HashSet<Annotation>();
      bindings.add(new OtherLiteral());
      MockInjectionPoint injectionPoint = new MockInjectionPoint(vanillaBean, Vanilla.class, injectedField, bindings);
      
      assert getCurrentManager().getInstanceToInject(injectionPoint) instanceof Vanilla;      
   }
   
   @Test(expectedExceptions = UnsatisfiedDependencyException.class)
   @SpecAssertion(section = "5.7.1", id = "f")
   public void testGetInstanceToInjectThrowsAmbiguousDependencyException() throws Exception
   {
      Bean<Vanilla> vanillaBean = getCurrentManager().resolveByType(Vanilla.class).iterator().next();
      
      Field injectedField = InjectedBean.class.getField("vanilla");
      Set<Annotation> bindings = new HashSet<Annotation>();
      bindings.add(new OtherLiteral());
      MockInjectionPoint injectionPoint = new MockInjectionPoint(vanillaBean, Vanilla.class, injectedField, bindings);      
      getCurrentManager().getInstanceToInject(injectionPoint);      
   }   
   
   @Test(expectedExceptions=UnproxyableDependencyException.class)
   @SpecAssertion(section = "5.7.1", id = "g")
   public void testGetInstanceToInjectThrowsUnproxyableDependencyException() throws Exception
   {
      final Bean<Mustard> bean = getCurrentManager().resolveByType(Mustard.class).iterator().next();
      final Set<Annotation> bindings = new HashSet<Annotation>();
      bindings.add(new OtherLiteral());
      
      Bean<Mustard> wrappedBean = new ForwardingBean<Mustard>(getCurrentManager())
      {

         @Override
         protected Bean<Mustard> delegate()
         {
            return bean;
         }
         
         @Override
         public Class<? extends Annotation> getScopeType()
         {
            return RequestScoped.class;
         }
         
         @Override
         public Set<Annotation> getBindings()
         {
            return bindings;
         }
         
         @Override
         public boolean equals(Object obj)
         {
            return this == obj;
         }
         
      };
      
      getCurrentManager().addBean(wrappedBean);
      
      Field injectedField = BrokenInjectedBean.class.getField("mustard");
      MockInjectionPoint injectionPoint = new MockInjectionPoint(bean, Mustard.class, injectedField, bindings);
      getCurrentManager().getInstanceToInject(injectionPoint);     
   }
}
