package org.jboss.jsr299.tck.tests.lookup.clientProxy;

import java.io.IOException;

import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
public class ClientProxyTest extends AbstractJSR299Test
{

   @Test
   @SpecAssertion(section = "5.4", id = "b")
   public void testClientProxyUsedForNormalScope()
   {
      Tuna tuna = getCurrentManager().getInstanceByType(Tuna.class);
      assert getCurrentConfiguration().getBeans().isProxy(tuna);
   }

   @Test
   @SpecAssertion(section = "5.4", id = "a")
   public void testClientProxyNotUsedForPseudoScope() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            Bean<Fox> foxBean = getCurrentManager().resolveByType(Fox.class).iterator().next();
            Fox fox = getCurrentManager().getInstance(foxBean);
            assert !getCurrentConfiguration().getBeans().isProxy(fox);
         }
         
      }.run();
   }
   
   @Test(groups="incontainer-ri-broken")
   @SpecAssertion(section = "5.4", id = "c")
   public void testSimpleWebBeanClientProxyIsSerializable() throws IOException, ClassNotFoundException
   {
      TunedTuna tuna = getCurrentManager().getInstanceByType(TunedTuna.class);
      assert getCurrentConfiguration().getBeans().isProxy(tuna);
      byte[] bytes = serialize(tuna);
      tuna = (TunedTuna) deserialize(bytes);
      assert getCurrentConfiguration().getBeans().isProxy(tuna);
      assert tuna.getState().equals("tuned");
   }

   @Test
   @SpecAssertion(section = "5.4.2", id = "a")
   public void testClientProxyInvocation()
   {
      Bean<TunedTuna> tunaBean = getCurrentManager().resolveByType(TunedTuna.class).iterator().next();
      TunedTuna tuna = getCurrentManager().getInstance(tunaBean);
      assert getCurrentConfiguration().getBeans().isProxy(tuna);
      assert tuna.getState().equals("tuned");
   }
   
}
