package org.jboss.jsr299.tck.tests.lookup.byname;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: Public Release Draft 2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class ResolutionByNameTest extends AbstractJSR299Test
{

   @Test(groups = { "resolution" })
   @SpecAssertion(section = "5.11", id = "c")
   public void testOnlyHighestPrecedenceResolved() throws Exception
   {
      // Both Cod and Plaice are named "whitefish" - Plaice has the highest
      // deployment type (AnotherDeploymentType)
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().resolveByName("whitefish").size() == 1;
            assert getCurrentManager().resolveByName("whitefish").iterator().next().getTypes().contains(Plaice.class);
         }
         
      }.run();
   }
}
