package org.jboss.jsr299.tck.tests.lookup.byname;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
public class InstantiationByNameTest extends AbstractJSR299Test
{
   
   @Test(groups={"stub", "resolution", "el"}) @SpecAssertion(section="5.10", id = "f")
   //TODO Need to find a way to intercept calls to the manager to verify this condition
   public void testGetInstanceByNameCalledOncePerDistinctNameInElExpression()
   {
      assert false;
   }
   

   @Test(groups = { "resolution", "el" })
   @SpecAssertions({
      @SpecAssertion(section = "5.10", id = "d"),
      @SpecAssertion(section = "5.10", id = "c")
   })
   public void testGetInstanceByName() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().resolveByName("nonexistant").size() == 0;
            assert getCurrentManager().getInstanceByName("nonexistant") == null;
            assert getCurrentManager().getInstanceByName("salmon") instanceof Salmon;
         }

      }.run();
   }
   
}
