package org.jboss.jsr299.tck.tests.implementation.simple.definition;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.jsr299.tck.tests.implementation.simple.definition.OuterClass.InnerClass_NotBeean;
import org.jboss.jsr299.tck.tests.implementation.simple.definition.OuterClass.StaticInnerClass;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 * 
 */
@Artifact
public class SimpleBeanDefinitionTest extends AbstractJSR299Test
{

   @Test
   @SpecAssertions({
      @SpecAssertion(section = "3.2.1", id = "ca"),
      @SpecAssertion(section = "3.2", id = "ca")
   })
   public void testAbstractClassDeclaredInJavaNotDiscovered()
   {
      assert getCurrentManager().resolveByType(Cow_NotBean.class).size() == 0;
   }

   @Test(groups = "innerClass")
   @SpecAssertions({
      @SpecAssertion(section = "3.2.1", id = "cc"),
      @SpecAssertion(section = "3.2.1", id = "ba")
   })
   public void testStaticInnerClassDeclaredInJavaAllowed()
   {
      assert getCurrentManager().resolveByType(StaticInnerClass.class).size() == 1;
   }

   @Test
   @SpecAssertions({
      @SpecAssertion(section = "3.2.1", id = "b"),
      @SpecAssertion(section = "3.2", id = "a")
   })
   public void testNonStaticInnerClassDeclaredInJavaNotDiscovered()
   {
      assert getCurrentManager().resolveByType(InnerClass_NotBeean.class).size() == 0;
   }

   @Test
   @SpecAssertions({
      @SpecAssertion(section = "3.2.1", id = "a"),
      @SpecAssertion(section = "3.2", id = "b")
   })
   public void testParameterizedClassDeclaredInJavaIsNotDiscovered()
   {
      assert getCurrentManager().resolveByType(ParameterizedClass_NotBean.class).size() == 0;
   }
   
   @Test
   @SpecAssertion(section = "3.2.1", id = "cb")
   public void testInterfaceNotDiscoveredAsSimpleBean()
   {
      assert getCurrentManager().resolveByType(Animal.class).size() == 0;
   }
   
   @Test
   @SpecAssertion(section = "3.2.1", id = "e")
   public void testEntityClassesNotDiscoveredAsSimpleBean()
   {
      assert getCurrentManager().resolveByType(MockEntity.class).size() == 0;
   }

   @Test
   @SpecAssertions( { 
      @SpecAssertion(section = "3.2.1", id = "g"), 
      @SpecAssertion(section = "3.2.1", id = "h"), 
      @SpecAssertion(section = "3.2.1", id = "i"), 
      @SpecAssertion(section = "3.2.1", id = "j"),
      @SpecAssertion(section = "3.2.1", id = "k")})
   public void testClassesImplementingServletInterfacesNotDiscoveredAsSimpleBeans()
   {
      assert getCurrentManager().resolveByType(MockFilter.class).size() == 0;
      assert getCurrentManager().resolveByType(MockHttpSessionListener.class).size() == 0;
      assert getCurrentManager().resolveByType(MockServlet.class).size() == 0;
      assert getCurrentManager().resolveByType(MockServletContextListener.class).size() == 0;
      assert getCurrentManager().resolveByType(MockServletRequestListener.class).size() == 0;
   }

   @Test
   @SpecAssertion(section="3.2.1", id="l")
   public void testClassesImplementingEnterpriseBeanInterfaceNotDiscoveredAsSimpleBean()
   {
      assert getCurrentManager().resolveByType(MockEnterpriseBean.class).size() == 0;
   }

   @Test
   @SpecAssertion(section="3.2.1", id="m")
   public void testClassExtendingUiComponentNotDiscoveredAsSimpleBean()
   {
      assert getCurrentManager().resolveByType(MockUIComponent.class).size() == 0;
   }

   @Test
   @SpecAssertion(section="3.2.1", id="p")
   public void testSimpleBeanOnlyIfConstructorParameterless()
   {
      assert getCurrentManager().resolveByType(Antelope_NotBean.class).isEmpty();
      assert !getCurrentManager().resolveByType(Donkey.class).isEmpty();
   }

   @Test
   @SpecAssertion(section="3.2.1", id="q")
   public void testSimpleBeanOnlyIfConstructorIsInitializer()
   {
      assert getCurrentManager().resolveByType(Antelope_NotBean.class).isEmpty();
      assert !getCurrentManager().resolveByType(Sheep.class).isEmpty();
   }

   @Test
   @SpecAssertion(section = "3.2.6.1", id = "a")
   public void testInitializerAnnotatedConstructor() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            Sheep.constructedCorrectly = false;
            getCurrentManager().getInstanceByType(Sheep.class);
            assert Sheep.constructedCorrectly;

         }
      }.run();

   }

   @Test
   @SpecAssertions({
      @SpecAssertion(section = "3.2.5", id = "a"), 
      @SpecAssertion(section = "3.2.6.1", id = "b"),
      @SpecAssertion(section = "3.1", id = "a"),
      @SpecAssertion(section = "3.2.3", id = "a")
   })
   public void testEmptyConstructorUsed()
   {
      Donkey.constructedCorrectly = false;
      getCurrentManager().getInstanceByType(Donkey.class);
      assert Donkey.constructedCorrectly;
   }

   @Test
   @SpecAssertion(section = "3.2.6.1", id = "a")
   public void testInitializerAnnotatedConstructorUsedOverEmptyConstuctor() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            getCurrentManager().getInstanceByType(Turkey.class);
            assert Turkey.constructedCorrectly;
         }
      }.run();
   }

   @Test
   @SpecAssertion(section = "3.2", id = "fa")
   public void testDependentScopedBeanCanHavePublicField() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().getInstanceByType(Tiger.class).name.equals("pete");
         }

      }.run();

   }

}
