package org.jboss.jsr299.tck.tests.implementation.producer.method.lifecycle;

import javax.inject.Current;
import javax.inject.Disposes;
import javax.inject.Produces;
import javax.inject.manager.Manager;

@AnotherDeploymentType
class SpiderProducer
{
   private static boolean tarantulaCreated;
   private static boolean tarantulaDestroyed;
   private static boolean destroyArgumentsSet;
   
   @Produces public Tarantula produceTarantula()
   {
      tarantulaCreated = true;
      tarantulaDestroyed = false;
      destroyArgumentsSet = false;;
      return new Tarantula("Pete");
   }
   
   @Produces @Null public Spider getNullSpider()
   {
      return null;
   }
   
   public static void destroyTarantula(@Disposes Tarantula spider, @Current Manager manager)
   {
      tarantulaDestroyed = true;
      if (manager != null)
      {
         destroyArgumentsSet = true;
      }
   }

   public static boolean isTarantulaCreated()
   {
      return tarantulaCreated;
   }

   public static boolean isTarantulaDestroyed()
   {
      return tarantulaDestroyed;
   }

   public static void setTarantulaCreated(boolean tarantulaCreated)
   {
      SpiderProducer.tarantulaCreated = tarantulaCreated;
   }

   public static void setTarantulaDestroyed(boolean tarantulaDestroyed)
   {
      SpiderProducer.tarantulaDestroyed = tarantulaDestroyed;
   }

   public static boolean isDestroyArgumentsSet()
   {
      return destroyArgumentsSet;
   }

   public static void setDestroyArgumentsSet(boolean destroyArgumentsSet)
   {
      SpiderProducer.destroyArgumentsSet = destroyArgumentsSet;
   }
}
