package org.jboss.jsr299.tck.tests.implementation.producer.field.definition.enterprise;

import java.lang.annotation.Annotation;

import javax.inject.AnnotationLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

@Artifact
@IntegrationTest
@Packaging(PackagingType.EAR)
@BeansXml("beans.xml")
public class EnterpriseProducerFieldDefinitionTest extends AbstractJSR299Test
{
   private static final Annotation FOO_LITERAL = new AnnotationLiteral<Foo>() {};   
   
   @Test(groups = {"producerField", "ri-broken"})
   @SpecAssertion(section = "4.2", id = "eb")
   public void testNonStaticProducerFieldNotInherited()
   {
      assert !(getCurrentManager().getInstanceByType(Egg.class, FOO_LITERAL).getMother() instanceof InfertileChicken);
   }

   @Test(groups = {"producerField", "ri-broken"})
   @SpecAssertion(section = "4.2", id = "ed")
   public void testNonStaticProducerFieldNotIndirectlyInherited()
   {
      assert !(getCurrentManager().getInstanceByType(Egg.class, FOO_LITERAL).getMother() instanceof LameInfertileChicken);
   }
}
