package org.jboss.jsr299.tck.tests.implementation.producer.field.definition;

import javax.annotation.Named;
import javax.inject.Produces;

@AnotherDeploymentType
class OtherSpiderProducer
{
   
   public static final Tarantula TARANTULA = new Tarantula();
   public static final BlackWidow BLACK_WIDOW = new BlackWidow();
   
   @Produces @Tame public Tarantula produceTarantula = TARANTULA;
   
   @Produces @Tame private BlackWidow produceBlackWidow = BLACK_WIDOW;
   
   private static Spider[] ALL_SPIDERS = { new Tarantula(), new LadybirdSpider(), new DaddyLongLegs() };
   @Produces public Spider[] getSpiders = ALL_SPIDERS;
   
   @Produces @Named("SpiderSize") public int getWolfSpiderSize = 4;
}
