package org.jboss.jsr299.tck.tests.implementation.enterprise.definition;

import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * @author Nicklas Karlsson
 * 
 * Spec version: PRD2
 */
@Artifact
@Packaging(PackagingType.EAR)
public class EnterpriseBeanDefinitionTest extends AbstractJSR299Test
{
   @Test(groups = { "enterpriseBeans" })
   @SpecAssertion(section = "3.3", id = "b")
   public void testStatelessWithDependentScopeOK()
   {
      assert getCurrentManager().resolveByType(GiraffeLocal.class).size() == 1;
   }

   @Test(groups = { "enterpriseBeans" })
   @SpecAssertion(section = "3.3", id = "c")
   public void testSingletonWithDependentScopeOK()
   {
      assert getCurrentManager().resolveByType(Labrador.class).size() == 1;
   }

   @Test(groups = { "enterpriseBeans" })
   @SpecAssertion(section = "3.3", id = "c")
   public void testSingletonWithApplicationScopeOK()
   {
      assert getCurrentManager().resolveByType(Laika.class).size() == 1;
   }

   @Test(groups = { "enterpriseBeans" })
   @SpecAssertion(section = "3.3.2", id = "a")
   public void testAnnotatedEnterpriseBean()
   {
      assert getCurrentManager().resolveByType(GiraffeLocal.class).size() > 0;
   }

   @Test(groups = { "enterpriseBeans", "ejbjarxml", "stub" })
   @SpecAssertion(section = "3.3.2", id = "b")
   public void testEJBJARDefinedEnterpriseBean()
   {
      // TODO dupe?
      assert false;
   }

   @Test(groups = { "enterpriseBeans" })
   @SpecAssertions( { 
      @SpecAssertion(section = "3.2.1", id = "f"), 
      @SpecAssertion(section = "3.3.3", id = "a"), 
      @SpecAssertion(section = "3.3.4", id = "c") } )
   public void testBeanTypesAreLocalInterfacesWithoutWildcardTypesOrTypeVariablesWithSuperInterfaces()
   {
      Bean<DogLocal> dogBean = getCurrentManager().resolveByType(DogLocal.class).iterator().next();
      assert dogBean.getTypes().contains(DogLocal.class);
      assert dogBean.getTypes().contains(PitbullLocal.class);
      assert !dogBean.getTypes().contains(Pitbull.class);
   }

   /**
    * If the EJB has a bean class local view and the bean class is not a
    * parameterized type, the set of bean types contains the bean class and all
    * superclasses.
    */
   @Test(groups = { "ejb 3.1", "ri-broken" })
   @SpecAssertion(section = "3.3.3", id = "b")
   public void testEnterpriseBeanWithLocalViewAndNotParameterizedTypeHasClassAndSuperclassesAsBeanTypes()
   {
      //TODO We need a 3.1 compliant container for this test
      Bean<DogLocal> dogBean = getCurrentManager().resolveByType(DogLocal.class).iterator().next();
      assert dogBean.getTypes().contains(Pitbull.class);
   }

   @Test(groups = "enterpriseBeans")
   @SpecAssertions({
      @SpecAssertion(section = "3.3.3", id = "c"),
      @SpecAssertion(section = "3.3.4", id = "a"),
      @SpecAssertion(section = "2.2", id = "l")
   })
   public void testObjectIsInAPITypes()
   {
      assert getCurrentManager().resolveByType(GiraffeLocal.class).size() == 1;
      assert getCurrentManager().resolveByType(GiraffeLocal.class).iterator().next().getTypes().contains(Object.class);
   }

   @Test(groups = { "enterpriseBeans" })
   @SpecAssertion(section = "3.3.3", id = "d")
   public void testRemoteInterfacesAreNotInAPITypes()
   {
      Bean<DogLocal> dogBean = getCurrentManager().resolveByType(DogLocal.class).iterator().next();
      assert !dogBean.getTypes().contains(DogRemote.class);
   }

   @Test(groups = "enterpriseBeans")
   @SpecAssertion(section = "3.3.8", id = "a")
   public void testDefaultName()
   {
      assert getCurrentManager().resolveByType(PitbullLocal.class).size() == 1;
      assert getCurrentManager().resolveByType(PitbullLocal.class).iterator().next().getName().equals("pitbull");
   }

}
