package org.jboss.jsr299.tck.tests.event.transactionalObservers;

import static javax.ejb.TransactionManagementType.BEAN;

import javax.annotation.Named;
import javax.annotation.Resource;
import javax.annotation.security.RunAs;
import javax.ejb.EJBException;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.inject.Current;
import javax.inject.manager.Manager;
import javax.transaction.UserTransaction;

@Stateless
@TransactionManagement(BEAN)
@RunAs("Bubba")
@Named
public class DogAgent implements Agent
{
   @Resource
   private UserTransaction userTransaction;

   @Current
   private Manager jsr299Manager;

   public void sendInTransaction(Object event)
   {
      try
      {
         userTransaction.begin();
         jsr299Manager.fireEvent(event);
         userTransaction.commit();
      }
      catch (Exception e)
      {
         throw new EJBException("Transaction failure", e);
      }
   }

   public void sendOutsideTransaction(Object event)
   {
      jsr299Manager.fireEvent(event);
   }
}
