package org.jboss.jsr299.tck.tests.event.resolve.type;

import java.util.Set;

import javax.event.Observer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class ChecksEventTypeWhenResolvingTest extends AbstractJSR299Test
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" })
   @SpecAssertion(section = "7.7", id = "f")
   public void testResolvingChecksEventType()
   {
      Observer<AnEventType> observer = new AnObserver();
      getCurrentManager().addObserver(observer, AnEventType.class);
      Set<Observer<AnEventType>> resolvedObservers = getCurrentManager().resolveObservers(new AnEventType());
      assert !resolvedObservers.isEmpty();
      Set<?> emptyObserverSet = getCurrentManager().resolveObservers(new UnusedEventType("name"));
      assert emptyObserverSet.isEmpty();
   }
}
