package org.jboss.jsr299.tck.tests.event.register.observer1;

import javax.event.Observer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class NonBindingTypesToRemoveObserverTest extends AbstractJSR299Test
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" }, expectedExceptions = { IllegalArgumentException.class })
   @SpecAssertion(section = "7.3", id = "m")
   public void testNonBindingTypePassedToRemoveObserverFails()
   {
      Observer<AnEventType> observer = new AnObserver();
      getCurrentManager().removeObserver(observer, AnEventType.class, new AnimalStereotypeAnnotationLiteral());
   }

}
