package org.jboss.jsr299.tck.tests.event.register.observer1;

import java.lang.annotation.Annotation;

import javax.event.Observer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class ConsumerNotifiedForEventTest extends AbstractJSR299Test
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" })
   @SpecAssertions( { 
      @SpecAssertion(section = "7.1", id = "h"), 
      @SpecAssertion(section = "7.3", id = "d"), 
      @SpecAssertion(section = "7.4", id = "b")
   })
   public void testConsumerNotifiedWhenEventTypeAndAllBindingsMatch()
   {
      Annotation roleBinding = new RoleBinding("Admin");
      AnObserver observer1 = new AnObserver();
      AnObserver observer2 = new AnObserver();
      getCurrentManager().addObserver(observer1, AnEventType.class);
      getCurrentManager().addObserver(observer2, AnEventType.class, roleBinding);

      // Fire an event that will be delivered to the two above observers
      AnEventType anEvent = new AnEventType();
      getCurrentManager().fireEvent(anEvent, roleBinding);

      assert observer1.wasNotified;
      assert observer2.wasNotified;
      observer1.wasNotified = false;
      observer2.wasNotified = false;
      
      // Fire an event that will be delivered to only one
      getCurrentManager().fireEvent(anEvent);
      assert observer1.wasNotified;
      assert !observer2.wasNotified;
      observer1.wasNotified = false;
      observer2.wasNotified = false;
      
      // Also make sure the binding value is considered
      getCurrentManager().fireEvent(anEvent, new RoleBinding("user"));
      assert observer1.wasNotified;
      assert !observer2.wasNotified;
   }


}
