/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.jsr299.tck.tests.event.broken.observer1;

import javax.inject.DefinitionException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ExpectedDeploymentException;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * Test an observer method on an EJB that is neither a business method
 * nor a static method of the class.
 * 
 * @author David Allen
 *
 */
@Artifact
@ExpectedDeploymentException(DefinitionException.class)
@Packaging(PackagingType.EAR)
public class EJBObserverMethodNotBusinessMethodTest extends AbstractJSR299Test
{
   @Test(groups = { "events" })
   @SpecAssertions( { @SpecAssertion(section = "7.5", id = "d"), @SpecAssertion(section = "7.5.2", id = "f")} )
   public void testObserverMethodOnEnterpriseBeanNotBusinessMethodOrStaticFails()
   {
      assert false;
   }
}
