package org.jboss.jsr299.tck.tests.event;

import java.util.Set;

import javax.event.Observer;
import javax.event.Observes;
import javax.inject.Current;
import javax.inject.manager.Manager;

/**
 * Simple bean with observer method and another injectable parameter.
 *
 */
class BananaSpider
{
   public void observeStringEvent(@Observes String someEvent, @Current Manager manager)
   {
      assert someEvent != null;
      assert manager != null;
      Set<Observer<String>> allStringObservers = manager.resolveObservers(someEvent);
      assert allStringObservers != null;
      assert allStringObservers.size() > 0;
   }
}
