package org.jboss.jsr299.tck.tests.definition.stereotype;

import java.lang.annotation.Annotation;

import javax.context.ApplicationScoped;
import javax.context.Dependent;
import javax.context.RequestScoped;
import javax.context.SessionScoped;
import javax.inject.AnnotationLiteral;
import javax.inject.Production;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class StereotypeDefinitionTest extends AbstractJSR299Test
{   
   private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>() {};

   @Test(groups = { "annotationDefinition" })
   @SpecAssertion(section = "2.7.1", id = "b")
   public void testHasStereotypeAnnotation()
   {
      Bean<Goat> bean = getCurrentManager().resolveByType(Goat.class).iterator().next();
      assert !bean.getDeploymentType().equals(HornedAnimalDeploymentType.class);
   }

   @Test
   @SpecAssertions({
      @SpecAssertion(section = "2.7.1.1", id = "a"),
      @SpecAssertion(section = "2.4.3", id = "c")
   })
   public void testStereotypeWithScopeType()
   {
      assert getCurrentManager().resolveByType(Moose.class).size() == 1; 
      assert getCurrentManager().resolveByType(Moose.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }

   @Test
   @SpecAssertions({
      @SpecAssertion(section = "2.7.1.1", id = "a"),
      @SpecAssertion(section="2.4.5", id = "b")
   })
   public void testStereotypeWithoutScopeType()
   {
      assert getCurrentManager().resolveByType(Reindeer.class).size() == 1; 
      assert getCurrentManager().resolveByType(Reindeer.class).iterator().next().getScopeType().equals(Dependent.class);
   }
      
   @Test
   @SpecAssertion(section = "2.7", id = "c")
   public void testOneStereotype()
   {
      Bean<LongHairedDog> bean = getCurrentManager().resolveByType(LongHairedDog.class).iterator().next();
      assert bean.getScopeType().equals(RequestScoped.class);
   }

   @Test
   @SpecAssertions({ 
      @SpecAssertion(section = "2.7.2", id = "e"), 
      @SpecAssertion(section = "2.7.4", id = "c"),
      @SpecAssertion(section  =  "2.7", id = "d")
      })
   public void testMultipleStereotypes()
   {
      assert getCurrentManager().resolveByType(HighlandCow.class, TAME_LITERAL).size() == 1; 
      Bean<HighlandCow> highlandCow = getCurrentManager().resolveByType(HighlandCow.class, TAME_LITERAL).iterator().next();
      assert highlandCow.getName() == null;
      assert highlandCow.getBindings().iterator().next().annotationType().equals(Tame.class);
      assert highlandCow.getScopeType().equals(RequestScoped.class);
      assert highlandCow.getDeploymentType().equals(HornedAnimalDeploymentType.class);
   }

   @Test
   @SpecAssertions( { @SpecAssertion(section = "2.7.2", id = "e"), 
      @SpecAssertion(section = "2.7.4", id = "c") })
   public void testMultipleStereotypesMergesScopes()
   {
      assert getCurrentManager().resolveByType(Springbok.class).size() == 1; 
      assert getCurrentManager().resolveByType(Springbok.class).iterator().next().getScopeType().equals(ApplicationScoped.class);
   }

   @Test
   @SpecAssertions( { @SpecAssertion(section = "2.7.1.4", id = "b"), 
      @SpecAssertion(section = "2.7.4", id = "a") })
   public void testRequiredTypeIsImplemented()
   {
      assert getCurrentManager().resolveByType(HighlandCow.class, TAME_LITERAL).size() == 1; 
      assert getCurrentManager().resolveByType(HighlandCow.class, TAME_LITERAL).iterator().next().getTypes().contains(Animal.class);
   }

   @Test
   @SpecAssertions( { @SpecAssertion(section = "2.7.1.4", id = "a"), 
      @SpecAssertion(section = "2.7.4", id = "b") })
   public void testScopeIsSupported()
   {
      assert getCurrentManager().resolveByType(Goldfish.class).size() == 1; 
      assert getCurrentManager().resolveByType(Goldfish.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }

   @Test
   @SpecAssertion(section = "4.1", id = "ab")
   public void testStereotypeDeclaredInheritedIsInherited() throws Exception
   {
      assert getCurrentManager().resolveByType(BorderCollie.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }

   @Test
   @SpecAssertion(section = "4.1", id = "ab")
   public void testStereotypeNotDeclaredInheritedIsNotInherited()
   {
      assert getCurrentManager().resolveByType(ShetlandPony.class).size() == 1; 
      assert getCurrentManager().resolveByType(ShetlandPony.class).iterator().next().getDeploymentType().equals(Production.class);
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "ah")
   public void testStereotypeDeclaredInheritedIsIndirectlyInherited()
   {
      assert getCurrentManager().resolveByType(EnglishBorderCollie.class).iterator().next().getScopeType().equals(RequestScoped.class);      
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "daa")
   public void testStereotypeScopeIsOverriddenByInheritedScope()
   {
      assert getCurrentManager().resolveByType(Chihuahua.class).iterator().next().getScopeType().equals(SessionScoped.class);      
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "dca")
   public void testStereotypeScopeIsOverriddenByIndirectlyInheritedScope()
   {
      assert getCurrentManager().resolveByType(MexicanChihuahua.class).iterator().next().getScopeType().equals(SessionScoped.class);      
   }   

}
