package org.jboss.jsr299.tck.tests.definition.scope.enterprise;

import javax.context.RequestScoped;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

@Artifact
@Packaging(PackagingType.EAR)
public class EnterpriseScopeDefinitionTest extends AbstractJSR299Test
{
   @Test @SpecAssertion(section="4.1", id = "bb")
   public void testScopeTypeDeclaredInheritedIsInherited() throws Exception
   {
      assert getCurrentManager().resolveByType(BorderCollieLocal.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "bd")
   public void testScopeTypeDeclaredInheritedIsIndirectlyInherited()
   {
      assert getCurrentManager().resolveByType(EnglishBorderCollieLocal.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }   
}
