package org.jboss.jsr299.tck.tests.definition.deployment;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;

import javax.inject.DeploymentType;
import javax.inject.Production;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: Public Release Draft 2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class DeploymentTypeDefinitionTest extends AbstractJSR299Test
{
   @Test(groups = { "annotationDefinition", "deploymentType" })
   @SpecAssertion(section = "2.5.2", id = "a")
   public void testDeploymentTypeHasCorrectTarget()
   {
      assert getCurrentManager().resolveByType(BlackWidow.class).size() == 1;
      Bean<BlackWidow> blackWidowSpiderModel = getCurrentManager().resolveByType(BlackWidow.class).iterator().next();
      
      Target target = blackWidowSpiderModel.getScopeType().getAnnotation(Target.class);
      List<ElementType> elements = Arrays.asList(target.value());
      assert elements.contains(ElementType.TYPE);
      assert elements.contains(ElementType.METHOD);
      assert elements.contains(ElementType.FIELD);
   }

   /**
    * 
    * TODO This text is not really a testable assertion
    */
   @Test(groups = { "annotationDefinition", "deploymentType" })
   @SpecAssertion(section = "2.5.2", id = "c")
   public void testDeploymentTypeDeclaresDeploymentTypeAnnotation()
   {
      assert getCurrentManager().resolveByType(BlackWidow.class).size() == 1;
      Bean<BlackWidow> blackWidowSpiderModel = getCurrentManager().resolveByType(BlackWidow.class).iterator().next();            
      assert blackWidowSpiderModel.getDeploymentType().getAnnotation(DeploymentType.class) != null;
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "2.5.3", id = "c")
   public void testDeploymentTypeInheritedFromDeclaringBean() throws Exception
   {
      assert getCurrentManager().resolveByType(BlackWidow.class).size() == 1;
      Bean<BlackWidow> blackWidowSpiderModel = getCurrentManager().resolveByType(BlackWidow.class).iterator().next();
      assert blackWidowSpiderModel.getDeploymentType().equals(AnotherDeploymentType.class);
   }

   @Test(groups = { "webbeansxml", "deploymentType" })
   @SpecAssertion(section = "2.5.5", id = "a")
   public void testDefaultDeploymentType()
   {
      assert getCurrentManager().resolveByType(Tarantula.class).size() == 1;
      Bean<Tarantula> bean = getCurrentManager().resolveByType(Tarantula.class).iterator().next();
      assert bean.getDeploymentType().equals(Production.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "2.5.5", id = "b")
   public void testHighestPrecedenceDeploymentTypeFromStereotype()
   {
      assert getCurrentManager().resolveByType(Rhinoceros.class).size() == 1;
      Bean<?> bean = getCurrentManager().resolveByType(Rhinoceros.class).iterator().next();
      assert bean.getDeploymentType().equals(HornedAnimalDeploymentType.class);
   }

   @Test(groups = { "beanLifecycle", "deploymentType" }, expectedExceptions = UnsatisfiedDependencyException.class)
   @SpecAssertion(section = "2.5.6", id = "a")
   public void testBeanWithDisabledDeploymentTypeNotInstantiated()
   {
      getCurrentManager().getInstanceByType(RedSnapper.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertions( { 
      @SpecAssertion(section = "2.5.5", id = "c"), 
      @SpecAssertion(section = "2.7.2", id = "da")
   })
   public void testWebBeanDeploymentTypeOverridesStereotype()
   {
      assert getCurrentManager().resolveByType(Reindeer.class).size() == 1;
      Bean<Reindeer> bean = getCurrentManager().resolveByType(Reindeer.class).iterator().next();
      assert bean.getDeploymentType().equals(Production.class);
   }
   
   @Test
   @SpecAssertion(section = "2.5.3", id = "i")   
   public void testDeploymentTypeMayBeSpecifiedByStereotype()
   {
      assert getCurrentManager().resolveByType(Goat.class).size() == 1;
      Bean<Goat> bean = getCurrentManager().resolveByType(Goat.class).iterator().next();
      assert bean.getDeploymentType().equals(HornedAnimalDeploymentType.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "ca")
   public void testDeploymentTypeDeclaredInheritedIsInherited() throws Exception
   {
      assert getCurrentManager().resolveByType(BorderCollie.class).size() == 1;
      assert getCurrentManager().resolveByType(BorderCollie.class).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "ca")
   public void testDeploymentTypeNotDeclaredInheritedIsNotInherited()
   {
      assert getCurrentManager().resolveByType(ShetlandPony.class).size() == 1;
      assert getCurrentManager().resolveByType(ShetlandPony.class).iterator().next().getDeploymentType().equals(Production.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "cc")
   public void testDeploymentTypeDeclaredInheritedIsBlockedByIntermediateDeploymentTypeNotMarkedInherited()
   {
      assert getCurrentManager().resolveByType(GoldenRetriever.class).size() == 1;
      assert getCurrentManager().resolveByType(GoldenRetriever.class).iterator().next().getDeploymentType().equals(Production.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "cc")
   public void testDeploymentTypeDeclaredInheritedIsBlockedByIntermediateDeploymentTypeMarkedInherited()
   {
      assert getCurrentManager().resolveByType(GoldenLabrador.class).size() == 1;
      assert getCurrentManager().resolveByType(GoldenLabrador.class).iterator().next().getDeploymentType().equals(InheritedDeploymentType.class);
   }

   @Test
   @SpecAssertion(section = "4.1", id = "dab")
   public void testDeploymentTypeIsOverriddenByInheritedDeploymentType()
   {
      assert getCurrentManager().resolveByType(Cow.class).size() == 1;
      assert getCurrentManager().resolveByType(Cow.class).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);      
   }
   
   @Test
   @SpecAssertion(section = "4.1", id = "dcb")
   public void testDeploymentTypeIsOverriddenByIndirectlyInheritedDeploymentType()
   {
      assert getCurrentManager().resolveByType(JerseyCow.class).size() == 1;
      assert getCurrentManager().resolveByType(JerseyCow.class).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);      
   }   

}
