package org.jboss.jsr299.tck.tests.context.request.ejb;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * EJB and related tests with the built-in request context.
 * 
 * @author David Allen
 *
 * Spec version: PRD2
 */
@Artifact
@IntegrationTest
@Packaging(PackagingType.EAR)
public class EJBRequestContextTest extends AbstractJSR299Test
{
   /**
    * The request scope is active during any remote method invocation of any EJB
    * bean, during any call to an EJB timeout method and during message delivery
    * to any EJB message driven bean.
    */
   @Test(groups = { "ri-broken", "contexts", "ejb3.1", "integration" })
   @SpecAssertion(section = "8.5.1", id = "i")
   public void testRequestScopeActiveDuringCallToEjbTimeoutMethod() throws Exception
   {
      FMS flightManagementSystem = getCurrentManager().getInstanceByType(FMS.class);
      flightManagementSystem.climb();
      Thread.sleep(250);
      assert flightManagementSystem.isRequestScopeActive();
   }

   /**
    * The request context is destroyed after the remote method invocation,
    * timeout or message delivery completes.
    */
   @Test(groups = { "ri-broken", "contexts", "ejb3.1", "integration" })
   @SpecAssertion(section = "8.5.1", id = "l")
   public void testRequestScopeDestroyedAfterCallToEjbTimeoutMethod() throws Exception
   {
      FMS flightManagementSystem = getCurrentManager().getInstanceByType(FMS.class);
      flightManagementSystem.climb();
      flightManagementSystem.descend();
      Thread.sleep(250);
      assert !flightManagementSystem.isSameBean();
      assert SimpleRequestBean.isBeanDestroyed();
   }

}
