package org.jboss.jsr299.tck.tests.context.request;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.war.WarArtifactDescriptor;
import org.testng.annotations.Test;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;

/**
 * 
 * Spec version: PRD2
 */
@Artifact
@IntegrationTest(runLocally=true)
@Resources({
  @Resource(destination=WarArtifactDescriptor.WEB_XML_DESTINATION, source="web.xml"),
  @Resource(destination="SimplePage.html", source="SimplePage.html")
})
public class RequestContextTest extends AbstractJSR299Test
{

   /**
    * The request scope is active during the service() method of any Servlet in
    * the web application.
    */
   @Test(groups = { "contexts", "servlet", "integration" })
   @SpecAssertion(section = "8.5.1", id = "a")
   public void testRequestScopeActiveDuringServiceMethod() throws Exception
   {
      WebClient webClient = new WebClient();
      webClient.setThrowExceptionOnFailingStatusCode(true);
      webClient.getPage(getContextPath() + "serviceMethodTest");
   }

   /**
    * The request scope is active during the doFilter() method of any Servlet in
    * the web application.
    */
   @Test(groups = { "contexts", "servlet", "integration" })
   @SpecAssertion(section = "8.5.1", id = "b")
   public void testRequestScopeActiveDuringServletFilter() throws Exception
   {
      WebClient webClient = new WebClient();
      webClient.setThrowExceptionOnFailingStatusCode(true);
      webClient.getPage(getContextPath() + "SimplePage.html");
   }

   /**
    * The request context is destroyed at the end of the servlet request, after
    * the Servlet service() method returns.
    */
   @Test(groups = { "contexts", "servlet", "integration" })
   @SpecAssertion(section = "8.5.1", id = "c")
   public void testRequestScopeIsDestroyedAfterServletRequest() throws Exception
   {
      WebClient webClient = new WebClient();
      webClient.setThrowExceptionOnFailingStatusCode(true);
      TextPage firstRequestResult = webClient.getPage(getContextPath() + "IntrospectRequest");
      assert firstRequestResult.getContent() != null;
      assert Double.parseDouble(firstRequestResult.getContent()) != 0;
      // Make a second request and make sure the same context is not there
      TextPage secondRequestResult = webClient.getPage(getContextPath() + "IntrospectRequest");
      assert secondRequestResult.getContent() != null;
      assert Double.parseDouble(secondRequestResult.getContent()) != Double.parseDouble(firstRequestResult.getContent());
      
      // As final confirmation that the context was destroyed, check that its beans
      // were also destroyed.
//      TextPage beanDestructionResult = webClient.getPage(getContextPath() + "InvalidateSession?isBeanDestroyed");
//      assert Boolean.parseBoolean(beanDestructionResult.getContent());
   }

   /**
    * The request scope is active during any Java EE web service invocation.
    */
   @Test(groups = { "stub", "contexts", "webservice", "integration" })
   @SpecAssertion(section = "8.5.1", id = "d")
   public void testRequestScopeActiveDuringWebSericeInvocation()
   {
      assert false;
   }

   /**
    * The request context is destroyed after the web service invocation
    * completes
    */
   @Test(groups = { "stub", "contexts", "webservice", "integration" })
   @SpecAssertion(section = "8.5.1", id = "e")
   public void testRequestScopeIsDestroyedAfterWebServiceInvocation()
   {
      assert false;
   }

   /**
    * The request scope is active during any remote method invocation of any EJB
    * bean, during any call to an EJB timeout method and during message delivery
    * to any EJB message driven bean.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "h")
   public void testRequestScopeActiveDuringRemoteMethodInvocationOfEjb()
   {
      assert false;
   }

   /**
    * The request scope is active during any remote method invocation of any EJB
    * bean, during any call to an EJB timeout method and during message delivery
    * to any EJB message driven bean.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "j")
   public void testRequestScopeActiveDuringEjbMessageDelivery()
   {
      assert false;
   }

   /**
    * The request context is destroyed after the remote method invocation,
    * timeout or message delivery completes.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "k")
   public void testRequestScopeDestroyedAfterRemoteMethodInvocationOfEjb()
   {
      assert false;
   }

   /**
    * The request context is destroyed after the remote method invocation,
    * timeout or message delivery completes.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "m")
   public void testRequestScopeDestroyedAfterEjbMessageDelivery()
   {
      assert false;
   }
}
