package org.jboss.jsr299.tck.tests.context.dependent;

import javax.annotation.PreDestroy;
import javax.context.Dependent;
import javax.inject.Current;
import javax.inject.Disposes;
import javax.inject.Produces;
import javax.inject.manager.Manager;

@AnotherDeploymentType
class SpiderProducer
{
   @Current
   private Manager manager;
   
   private static boolean dependentContextActive = false;
   private static boolean destroyed = false;
   private static SpiderProducer instanceUsedForDisposal = null;
   
   
   @Produces public Tarantula produceTarantula()
   {
      if (manager.getContext(Dependent.class).isActive())
      {
         dependentContextActive = true;
      }
      return new Tarantula();
   }

   public void disposeTarantula(@Disposes Tarantula tarantula)
   {
      if (manager.getContext(Dependent.class).isActive())
      {
         dependentContextActive = true;
      }
      instanceUsedForDisposal = this;
   }

   public static boolean isDependentContextActive()
   {
      return dependentContextActive;
   }

   public static void setDependentContextActive(boolean dependentContextActive)
   {
      SpiderProducer.dependentContextActive = dependentContextActive;
   }

   public static SpiderProducer getInstanceUsedForDisposal()
   {
      return instanceUsedForDisposal;
   }
   
   public static boolean isDestroyed()
   {
      return destroyed;
   }
   
   public static void setDestroyed(boolean destroyed)
   {
      SpiderProducer.destroyed = destroyed;
   }
   
   @PreDestroy
   public void destroy()
   {
      destroyed = true;
   }
}
