package org.jboss.jsr299.tck.tests.context.dependent;

import javax.annotation.PreDestroy;
import javax.context.Dependent;
import javax.event.Observes;
import javax.inject.Current;
import javax.inject.Initializer;
import javax.inject.manager.Manager;

@Dependent
class HorseStable
{
   private static boolean dependentContextActive = false;
   private static HorseStable instanceThatObservedEvent = null;
   private static boolean destroyed = false;

   @Initializer
   public HorseStable(@Current Manager manager)
   {
      if (manager.getContext(Dependent.class).isActive())
      {
         dependentContextActive = true;
      }
   }

   public void horseEntered(@Observes HorseInStableEvent horseEvent)
   {
      instanceThatObservedEvent = this;
   }
   
   @PreDestroy
   public void destroy()
   {
      destroyed = true;
   }

   public static boolean isDependentContextActive()
   {
      return dependentContextActive;
   }

   public static void setDependentContextActive(boolean dependentContextActive)
   {
      HorseStable.dependentContextActive = dependentContextActive;
   }

   public static HorseStable getInstanceThatObservedEvent()
   {
      return instanceThatObservedEvent;
   }
   
   public static void setInstanceThatObservedEvent(HorseStable instanceThatObservedEvent)
   {
      HorseStable.instanceThatObservedEvent = instanceThatObservedEvent;
   }
   
   public static boolean isDestroyed()
   {
      return destroyed;
   }
   
   public static void setDestroyed(boolean destroyed)
   {
      HorseStable.destroyed = destroyed;
   }
}
