package org.jboss.jsr299.tck.tests.context.conversation.client;

import java.io.Serializable;

import javax.annotation.Named;
import javax.annotation.PreDestroy;
import javax.context.ConversationScoped;

@ConversationScoped
@Named
public class Cloud implements Serializable
{
   
   public static final String NAME = Cloud.class.getName() + ".Pete";
   
   public static final String RAINED_HEADER_NAME = Cloud.class.getName() + ".rained";
   
   private static boolean destroyed = false;

   private boolean rained;
   
   @PreDestroy
   public void destroy()
   {
      destroyed = true;
   }
   
   public static boolean isDestroyed()
   {
      return destroyed;
   }
   
   public static void setDestroyed(boolean destroyed)
   {
      Cloud.destroyed = destroyed;
   }
   
   public String getName()
   {
      return NAME;
   }
   
   public String getRain()
   {
      rained = true;
      return "rain!";
   }
   
   public boolean isRained()
   {
      return rained;
   }
   
}
