package org.jboss.jsr299.tck.tests.context.conversation;

import javax.context.Conversation;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * @author Nicklas Karlsson
 * 
 * Spec version: PRD2
 */
@Artifact
public class ConversationEndTest extends AbstractJSR299Test
{
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "g")
   public void testConversationEndMakesConversationTransient()
   {
      Conversation conversation = getCurrentManager().getInstanceByType(Conversation.class);
      conversation.begin();
      assert conversation.isLongRunning();
      conversation.end();
      assert !conversation.isLongRunning();
   }

}