package org.jboss.jsr299.tck.tests.context.application.standalone;

import javax.context.ApplicationScoped;
import javax.event.Asynchronously;
import javax.event.Observes;
import javax.inject.Current;
import javax.inject.manager.Manager;

class TcasDisplay
{
   @Current
   private Manager manager;
   
   private static boolean applicationScopeActive = false;
   
   public void drawTarget(@Observes @Asynchronously TargetEvent targetEvent)
   {
      if (manager.getContext(ApplicationScoped.class).isActive())
      {
         applicationScopeActive = true;
      }
      else
      {
         applicationScopeActive = false;
      }
   }

   public void drawNearMiss(@Observes @Asynchronously NearMiss event)
   {
      event.setBean(manager.getInstanceByType(SimpleApplicationBean.class));
   }

   public static boolean isApplicationScopeActive()
   {
      return applicationScopeActive;
   }

   public static void setApplicationScopeActive(boolean applicationScopeActive)
   {
      TcasDisplay.applicationScopeActive = applicationScopeActive;
   }
}
