package org.jboss.jsr299.tck.tests.context.application.ejb;

import javax.annotation.Resource;
import javax.context.ApplicationScoped;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.inject.Current;
import javax.inject.manager.Manager;

@Stateless
public class FMSModelIII implements FMS
{
   private static final long serialVersionUID = 1L;

   @Resource
   private TimerService timerService;
   
   @Current
   private Manager manager;

   private static boolean applicationScopeActive = false;
   private static double beanId = 0.0d;
   private static boolean sameBean = false;

   public void climb()
   {
      timerService.createTimer(200, "Climb command timeout");
   }

   public void descend()
   {
      timerService.createTimer(100, "Descend command timeout");
      beanId = 0.0d;
      sameBean = false;
   }

   public void turnLeft()
   {
   }

   public void turnRight()
   {
   }

   @Timeout
   public void timeout(Timer timer)
   {
      if (manager.getContext(ApplicationScoped.class).isActive())
      {
         applicationScopeActive = true;
         if (beanId > 0.0)
         {
            if (beanId == manager.getInstanceByType(SimpleApplicationBean.class).getId())
            {
               sameBean = true;
            }
         }
         else
         {
            beanId = manager.getInstanceByType(SimpleApplicationBean.class).getId();
         }
      }
   }

   public boolean isApplicationScopeActive()
   {
      return applicationScopeActive;
   }

   public void setApplicationScopeActive(boolean applicationScopeActive)
   {
      FMSModelIII.applicationScopeActive = applicationScopeActive;
   }

   public boolean isSameBean()
   {
      return sameBean;
   }

}
