/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.jsr299.tck.tests.context.application;

import java.io.IOException;

import javax.context.ApplicationScoped;
import javax.inject.Current;
import javax.inject.manager.Manager;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet used just to test context during service method.
 * 
 * @author David Allen
 *
 */
public class ServiceMethodServlet extends HttpServlet
{

   private static final long serialVersionUID = 1L;
   
   @Current
   private Manager jsr299Manager;

   @Override
   protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
   {
      if (!jsr299Manager.getContext(ApplicationScoped.class).isActive())
      {
         throw new ServletException("Application context is not active");
      }
      else
      {
         super.service(req, resp);
      }
   }

   @Override
   protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
   {
      resp.setContentType("text/text");
      resp.getWriter().println("It worked!");
   }

   @Override
   public void init() throws ServletException
   {
      //TODO Remove init code once injection works in servlet container
      try
      {
         InitialContext ic = new InitialContext();
         jsr299Manager = (Manager) ic.lookup("java:app/Manager");
      }
      catch (NamingException e)
      {
         throw new ServletException("Error looking up manager", e);
      }
   }

   @Override
   public void init(ServletConfig config) throws ServletException
   {
      init();
   }
}
