package org.jboss.jsr299.tck.tests.context;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import javax.context.CreationalContext;
import javax.context.SessionScoped;
import javax.inject.Standard;
import javax.inject.manager.Bean;
import javax.inject.manager.InjectionPoint;
import javax.inject.manager.Manager;

class MyContextual extends Bean<MySessionBean>
{
   private boolean createCalled = false;
   private boolean destroyCalled = false;
   private boolean shouldReturnNullInstances = false;

   protected MyContextual(Manager manager)
   {
      super(manager);
   }

   @Override
   public Set<Annotation> getBindings()
   {
      return Collections.emptySet();
   }

   @Override
   public Class<? extends Annotation> getDeploymentType()
   {
      return Standard.class;
   }

   @Override
   public Set<? extends InjectionPoint> getInjectionPoints()
   {
      return Collections.emptySet();
   }

   @Override
   public String getName()
   {
      return "my-session-bean";
   }

   @Override
   public Class<? extends Annotation> getScopeType()
   {
      return SessionScoped.class;
   }

   @SuppressWarnings("unchecked")
   @Override
   public Set<Type> getTypes()
   {
      return new HashSet<Type>(Arrays.asList(Object.class, MySessionBean.class, Serializable.class));
   }

   @Override
   public boolean isNullable()
   {
      return false;
   }

   @Override
   public boolean isSerializable()
   {
      return true;
   }

   public MySessionBean create(CreationalContext<MySessionBean> creationalContext)
   {
      createCalled = true;
      if (shouldReturnNullInstances)
         return null;
      else
         return new MySessionBean();
   }

   public void destroy(MySessionBean instance)
   {
      destroyCalled = true;
   }

   public boolean isCreateCalled()
   {
      return createCalled;
   }

   public boolean isDestroyCalled()
   {
      return destroyCalled;
   }

   public void setShouldReturnNullInstances(boolean shouldReturnNullInstances)
   {
      this.shouldReturnNullInstances = shouldReturnNullInstances;
   }

}
