package org.jboss.jsr299.tck.tests.context;

import javax.context.ApplicationScoped;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.SessionScoped;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class GetTest extends AbstractJSR299Test
{
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.1", id = "e")
   public void testGetMayNotCreateNewInstanceUnlessCreationalContextGiven()
   {
      Contextual<MySessionBean> mySessionBean = getCurrentManager().resolveByType(MySessionBean.class).iterator().next();
      assert getCurrentManager().getContext(SessionScoped.class).get(mySessionBean) == null;

      Contextual<MyApplicationBean> myApplicationBean = getCurrentManager().resolveByType(MyApplicationBean.class).iterator().next();
      assert getCurrentManager().getContext(ApplicationScoped.class).get(myApplicationBean) == null;

      // Now try same operation with a CreationalContext
      CreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      assert getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, myCreationalContext) != null;

      CreationalContext<MyApplicationBean> myOtherCreationalContext = new MyCreationalContext<MyApplicationBean>();
      assert getCurrentManager().getContext(ApplicationScoped.class).get(myApplicationBean, myOtherCreationalContext) != null;
   }
   
}
