package org.jboss.jsr299.tck.tests.context;

import javax.context.ApplicationScoped;
import javax.context.SessionScoped;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class DestroyedInstanceReturnedByGetTest extends AbstractJSR299Test
{
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.1", id = "g")
   public void testDestroyedInstanceMustNotBeReturnedByGet()
   {
      Bean<MySessionBean> mySessionBean = getCurrentManager().resolveByType(MySessionBean.class).iterator().next();
      MyCreationalContext<MySessionBean> myCreationalContext = new MyCreationalContext<MySessionBean>();
      MySessionBean beanInstance = getCurrentManager().getContext(SessionScoped.class).get(mySessionBean, myCreationalContext);
      assert beanInstance != null;
      this.destroyContext(getCurrentManager().getContext(SessionScoped.class));
      this.setContextActive(getCurrentManager().getContext(SessionScoped.class));
      beanInstance = getCurrentManager().getContext(SessionScoped.class).get(mySessionBean);
      assert beanInstance == null;
      
      Bean<MyApplicationBean> myApplicationBean = getCurrentManager().resolveByType(MyApplicationBean.class).iterator().next();
      MyCreationalContext<MyApplicationBean> myCreationalContextForApplication = new MyCreationalContext<MyApplicationBean>();
      MyApplicationBean myApplicationBeanInstance = getCurrentManager().getContext(ApplicationScoped.class).get(myApplicationBean, myCreationalContextForApplication);
      assert myApplicationBeanInstance != null;
      this.destroyContext(getCurrentManager().getContext(ApplicationScoped.class));
      this.setContextActive(getCurrentManager().getContext(ApplicationScoped.class));

      myApplicationBeanInstance = getCurrentManager().getContext(ApplicationScoped.class).get(myApplicationBean);
      assert myApplicationBeanInstance == null;
   }
   
}
