package org.jboss.jsr299.tck.tests.context;

import java.lang.annotation.Annotation;

import javax.context.ApplicationScoped;
import javax.context.Context;
import javax.context.ContextNotActiveException;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.context.Dependent;
import javax.context.RequestScoped;
import javax.context.SessionScoped;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 */
@Artifact
public class ContextTest extends AbstractJSR299Test
{

   private @interface Dummy
   {

   }

   private @interface Unregistered
   {

   }

   private static class DummyContext implements Context
   {

      public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext)
      {
         throw new UnsupportedOperationException();
      }

      public <T> T get(Contextual<T> contextual)
      {
         return get(contextual, null);
      }

      public Class<? extends Annotation> getScopeType()
      {
         return Dummy.class;
      }

      public boolean isActive()
      {
         return true;
      }
   }

   @Test(expectedExceptions = { IllegalStateException.class }, groups = { "manager" })
   @SpecAssertion(section = "8.6", id = "d")
   public void testGetContextWithTooManyActiveContextsFails()
   {
      Context firstContext = new DummyContext()
      {
      };
      Context secondContext = new DummyContext()
      {
      };
      getCurrentManager().addContext(firstContext);
      getCurrentManager().addContext(secondContext);
      getCurrentManager().getContext(Dummy.class);
   }

   @Test(expectedExceptions = { ContextNotActiveException.class }, groups = { "manager" })
   @SpecAssertion(section = "8.6", id = "c")
   public void testGetContextWithNoRegisteredContextsFails()
   {
      getCurrentManager().getContext(Unregistered.class);
   }

   /**
    * For each of the built-in normal scopes, contexts propagate across any Java
    * method call, including invocation of EJB local business methods.
    */
   @Test(groups = { "stub", "contexts", "underInvestigation" })
   @SpecAssertion(section = "8.5", id = "b")
   public void testBuiltInNormalScopedContextsPropagateAcrossAnyJavaMethodCall()
   {
      assert false;
   }

   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5", id = "a")
   public void testBuiltInContexts()
   {
      Context context = getCurrentManager().getContext(Dependent.class);
      assert context != null;
      context = getCurrentManager().getContext(RequestScoped.class);
      assert context != null;
      context = getCurrentManager().getContext(SessionScoped.class);
      assert context != null;
      context = getCurrentManager().getContext(ApplicationScoped.class);
      assert context != null;
   }
}
