package org.jboss.jsr299.tck.tests.activities.current;

import java.lang.annotation.Annotation;

import javax.context.Context;
import javax.context.Contextual;
import javax.context.CreationalContext;
import javax.event.Observer;
import javax.inject.manager.Manager;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractJSR299Test;
import org.jboss.testharness.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class EventCurrentActivityTest extends AbstractJSR299Test
{
   
   static interface TestableObserver<T> extends Observer<T>
   {
      
      boolean isObserved();
      
   }
   
   
   private static class DummyContext implements Context
   {
      
      private boolean active = true;

      public <T> T get(Contextual<T> contextual)
      {
         return null;
      }

      public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext)
      {
         return null;
      }

      public Class<? extends Annotation> getScopeType()
      {
         return Dummy.class;
      }

      public boolean isActive()
      {
         return active;
      }
      
      public void setActive(boolean active)
      {
         this.active = active;
      }
      
   }
   
   @Test
   @SpecAssertions({
      @SpecAssertion(section="11.6.1", id="g")
   })
   public void testEventProcessedByCurrentActivity()
   {
      Context dummyContext = new DummyContext();
      getCurrentManager().addContext(dummyContext);
      Manager childActivity = getCurrentManager().createActivity();
      TestableObserver<NightTime> observer = new TestableObserver<NightTime>()
      {
         
         boolean observed = false;

         public void notify(NightTime event)
         {
            observed = true;
         }
         
         public boolean isObserved()
         {
            return observed;
         }
         
      };
      childActivity.addObserver(observer, NightTime.class);
      childActivity.setCurrent(dummyContext.getScopeType());
      getCurrentManager().getInstanceByType(Dusk.class).ping();
      assert observer.isObserved();
   }
   
}
