/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.accessor.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.reflect.plugins.bytecode.accessor.ConstructorAccessor;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReflectConstructorAccessor
implements ConstructorAccessor {
    private final Constructor<?> ctor;

    ReflectConstructorAccessor(Constructor<?> ctor) {
        this.ctor = ctor;
        if (ctor != null && !Modifier.isPublic(ctor.getModifiers()) || !Modifier.isPublic(ctor.getDeclaringClass().getModifiers())) {
            this.setAccessible();
        }
    }

    @Override
    public Object newInstance(Object[] args) throws Throwable {
        return ReflectionUtils.newInstance(this.ctor, args);
    }

    private void setAccessible() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            this.ctor.setAccessible(true);
        } else {
            AccessController.doPrivileged(new SetAccessible());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetAccessible
    implements PrivilegedAction<Object> {
        private SetAccessible() {
        }

        @Override
        public Object run() {
            ReflectConstructorAccessor.this.ctor.setAccessible(true);
            return null;
        }
    }
}

