/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import javassist.CtBehavior;
import javassist.CtClass;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.javassist.JavassistHelper;

abstract class JavassistTypeVariableSpy {
    JavassistTypeVariableSpy() {
    }

    static JavassistTypeVariableSpy createForBehavior(CtBehavior behavior, SignatureAttribute.MethodSignature sig) {
        return new MethodTypeVariable(behavior.getDeclaringClass(), sig);
    }

    static JavassistTypeVariableSpy createForClass(SignatureAttribute.ClassSignature sig) {
        return new ClassTypeVariable(sig);
    }

    static JavassistTypeVariableSpy createForField(SignatureAttribute.ClassSignature sig) {
        return new ClassTypeVariable(sig);
    }

    abstract SignatureAttribute.Type getTypeBound(SignatureAttribute.TypeVariable var1);

    private static SignatureAttribute.Type getTypeFromTypeParameters(SignatureAttribute.TypeVariable tv, SignatureAttribute.TypeParameter[] parameters) {
        if (parameters == null) {
            return null;
        }
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].getName().equals(tv.getName())) continue;
            SignatureAttribute.ObjectType type = parameters[i].getClassBound();
            if (type != null) {
                return type;
            }
            SignatureAttribute.ObjectType[] types = parameters[i].getInterfaceBound();
            if (types == null || types.length <= 0) break;
            return types[0];
        }
        return null;
    }

    private static class ClassTypeVariable
    extends JavassistTypeVariableSpy {
        private final SignatureAttribute.ClassSignature sig;

        public ClassTypeVariable(SignatureAttribute.ClassSignature sig) {
            this.sig = sig;
        }

        SignatureAttribute.Type getTypeBound(SignatureAttribute.TypeVariable tv) {
            SignatureAttribute.Type type = JavassistTypeVariableSpy.getTypeFromTypeParameters(tv, this.sig.getParameters());
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("No type parameter found called " + tv.getName() + " in " + this.sig);
        }
    }

    private static class MethodTypeVariable
    extends JavassistTypeVariableSpy {
        protected final CtClass clazz;
        private final SignatureAttribute.MethodSignature sig;

        MethodTypeVariable(CtClass clazz, SignatureAttribute.MethodSignature sig) {
            this.clazz = clazz;
            this.sig = sig;
        }

        SignatureAttribute.Type getTypeBound(SignatureAttribute.TypeVariable tv) {
            SignatureAttribute.Type type = JavassistTypeVariableSpy.getTypeFromTypeParameters(tv, this.sig.getTypeParameters());
            if (type != null) {
                return type;
            }
            SignatureAttribute.ClassSignature classSig = JavassistHelper.getClassSignature(this.clazz);
            type = JavassistTypeVariableSpy.getTypeFromTypeParameters(tv, classSig.getParameters());
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("No type parameter found called " + tv.getName() + " in " + this.sig + " or in " + classSig);
        }
    }
}

