/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.util.HashMap;
import org.jboss.reflect.plugins.AbstractAnnotatedInfo;
import org.jboss.reflect.spi.AnnotationInfo;
import org.jboss.reflect.spi.AnnotationValue;

public class AnnotationHolder
extends AbstractAnnotatedInfo {
    private static final long serialVersionUID = 3546645408219542832L;
    private static final AnnotationValue[] EMPTY_ANNOTATIONS_ARRAY = new AnnotationValue[0];
    private static final HashMap<String, AnnotationValue> EMPTY_ANNOTATION_MAP = new HashMap();
    protected AnnotationValue[] annotationsArray;
    protected HashMap<String, AnnotationValue> annotationMap;

    public AnnotationHolder() {
    }

    public AnnotationHolder(AnnotationValue[] annotations) {
        this.setupAnnotations(annotations);
    }

    public AnnotationValue[] getAnnotations() {
        return this.annotationsArray;
    }

    public AnnotationValue getAnnotation(String name) {
        if (this.annotationMap == null) {
            return null;
        }
        return this.annotationMap.get(name);
    }

    public boolean isAnnotationPresent(String name) {
        if (this.annotationMap == null) {
            return false;
        }
        return this.annotationMap.containsKey(name);
    }

    protected void setupAnnotations(AnnotationValue[] annotations) {
        if (annotations != null && annotations.length > 0) {
            this.annotationsArray = annotations;
            this.annotationMap = new HashMap();
            for (int i = 0; i < annotations.length; ++i) {
                AnnotationInfo type = annotations[i].getAnnotationType();
                this.annotationMap.put(type.getName(), annotations[i]);
            }
        } else {
            this.annotationMap = EMPTY_ANNOTATION_MAP;
            this.annotationsArray = EMPTY_ANNOTATIONS_ARRAY;
        }
    }
}

