/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.OSUtils;

@Alias(value="cd")
@Topic(value="File & Resources")
@Help(value="Change the current directory")
public class ChangeDirectoryPlugin
implements Plugin {
    private final Shell shell;

    @Inject
    public ChangeDirectoryPlugin(Shell shell) {
        this.shell = shell;
    }

    @DefaultCommand
    public void run(@Option(description="The new directory", defaultValue="~") Resource<?> r) {
        if (r != null) {
            String userHomePath;
            String fullyQualifiedName;
            Project currentProject = this.shell.getCurrentProject();
            if (!r.exists()) {
                if ("~".equals(r.getName()) && currentProject.exists()) {
                    r = currentProject.getProjectRoot();
                } else {
                    throw new RuntimeException("no such resource: " + r.toString());
                }
            }
            if ((fullyQualifiedName = r.getFullyQualifiedName()).startsWith(userHomePath = OSUtils.getUserHomePath()) && "~".equals(r.getFullyQualifiedName().substring(userHomePath.length()))) {
                r = currentProject.getProjectRoot();
            }
            this.shell.setCurrentResource((Resource)r);
        }
    }
}

