/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.completer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.parser.CommandParser;
import org.jboss.forge.shell.command.parser.CommandParserContext;
import org.jboss.forge.shell.command.parser.CompositeCommandParser;
import org.jboss.forge.shell.command.parser.NamedBooleanOptionParser;
import org.jboss.forge.shell.command.parser.NamedValueOptionParser;
import org.jboss.forge.shell.command.parser.NamedValueVarargsOptionParser;
import org.jboss.forge.shell.command.parser.OrderedValueOptionParser;
import org.jboss.forge.shell.command.parser.OrderedValueVarargsOptionParser;
import org.jboss.forge.shell.completer.CommandCompleter;
import org.jboss.forge.shell.completer.CommandCompleterState;
import org.jboss.forge.shell.completer.PluginCommandCompleterState;

public class OptionResolverCompleter
implements CommandCompleter {
    private final CommandParser commandParser = new CompositeCommandParser(new NamedBooleanOptionParser(), new NamedValueOptionParser(), new NamedValueVarargsOptionParser(), new OrderedValueOptionParser(), new OrderedValueVarargsOptionParser());

    public void complete(CommandCompleterState st) {
        PluginCommandCompleterState state = (PluginCommandCompleterState)st;
        CommandMetadata command = state.getCommand();
        if (command != null && command.hasOptions()) {
            this.getOptionCandidates(command, state);
        }
    }

    private void getOptionCandidates(CommandMetadata command, PluginCommandCompleterState state) {
        ArrayList<String> results = new ArrayList<String>();
        Queue<String> tokens = state.getTokens();
        CommandParserContext context = new CommandParserContext();
        context.setCompleting(true);
        context.setFinalTokenComplete(state.isFinalTokenComplete());
        this.commandParser.parse(state.getCommand(), tokens, context);
        state.setCommandContext(context);
        Map<OptionMetadata, Object> valueMap = context.getValueMap();
        List options = command.getOptions();
        if (tokens.isEmpty()) {
            if (state.isFinalTokenComplete()) {
                if (context.isEmpty() || context.isLastOptionValued()) {
                    for (OptionMetadata option : options) {
                        if (valueMap.containsKey(option)) continue;
                        if (option.isNamed() && option.isRequired()) {
                            results.clear();
                            results.add("--" + option.getName() + " ");
                        } else {
                            if (option.isNamed()) {
                                results.add("--" + option.getName() + " ");
                                continue;
                            }
                            if (option.isNamed() || option.isPipeOut() || option.isPipeIn()) continue;
                            state.setOption(option);
                        }
                        break;
                    }
                } else if (!context.isEmpty() && !context.isLastOptionValued()) {
                    state.setOption(context.getLastParsed());
                }
            } else if (!state.isFinalTokenComplete() && !context.isEmpty()) {
                state.setOption(context.getLastParsed());
                if (context.isLastOptionValued()) {
                    state.getTokens().add(context.getLastParsedToken());
                }
            }
        } else {
            String finalToken = tokens.peek();
            int finalTokenIndex = state.getBuffer().lastIndexOf(finalToken);
            boolean tailOptionValued = true;
            boolean finalTokenIsValue = false;
            if (!finalToken.startsWith("-")) {
                finalTokenIsValue = true;
                finalTokenIndex = state.getIndex();
            } else {
                boolean shortOption = finalToken.matches("^-[^\\-]+$") && finalToken.length() > 1;
                finalToken = finalToken.replaceFirst("^[-]+", "");
                for (Map.Entry<OptionMetadata, Object> entry : valueMap.entrySet()) {
                    OptionMetadata option = entry.getKey();
                    if (entry.getValue() == null) {
                        tailOptionValued = false;
                    }
                    if ((!option.getShortName().equals(finalToken) || !shortOption) && !option.getName().equals(finalToken)) continue;
                    state.setOption(option);
                }
                if (tailOptionValued) {
                    for (OptionMetadata option : options) {
                        if (!option.isNamed()) continue;
                        if ((option.getShortName().equals(finalToken) && shortOption || option.getName().equals(finalToken)) && valueMap.containsKey(option)) {
                            if (state.isFinalTokenComplete()) break;
                            results.add(" ");
                            break;
                        }
                        if (!option.getName().startsWith(finalToken) || valueMap.containsKey(option)) continue;
                        results.add("--" + option.getName() + " ");
                    }
                }
                if (!results.isEmpty()) {
                    tokens.remove();
                }
                if (results.isEmpty() && tailOptionValued) {
                    for (OptionMetadata option : options) {
                        if (!option.isNamed() || valueMap.containsKey(option) || !option.isRequired() && !state.isDuplicateBuffer()) continue;
                        results.add("--" + option.getName() + " ");
                    }
                }
            }
            if (!state.isFinalTokenComplete() && finalTokenIsValue) {
                state.setOption(context.getLastParsed());
                results.clear();
                if (state.isDuplicateBuffer()) {
                    results.add(" ");
                }
            } else if (!results.isEmpty() && tailOptionValued) {
                state.setIndex(finalTokenIndex);
            }
        }
        state.getCandidates().addAll(results);
    }
}

