/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.completer;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import javax.inject.Inject;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.PluginMetadata;
import org.jboss.forge.shell.completer.CommandCompleter;
import org.jboss.forge.shell.completer.CommandCompleterState;
import org.jboss.forge.shell.completer.PluginCommandCompleter;
import org.jboss.forge.shell.completer.PluginCommandCompleterState;

public class CommandResolverCompleter
implements CommandCompleter {
    @Inject
    private Shell shell;

    public void complete(CommandCompleterState st) {
        PluginCommandCompleterState state = (PluginCommandCompleterState)st;
        if (state.getPlugin() != null) {
            String peek;
            Queue<String> tokens = state.getTokens();
            state.setIndex(state.getBuffer().length());
            PluginMetadata plugin = state.getPlugin();
            if (tokens.size() > 1) {
                peek = tokens.peek();
                if (plugin.hasCommand(peek, this.shell)) {
                    CommandMetadata command = plugin.getCommand(tokens.remove());
                    state.setCommand(command);
                } else if (plugin.hasDefaultCommand()) {
                    CommandMetadata defaultCommand = plugin.getDefaultCommand();
                    state.setCommand(defaultCommand);
                }
            } else if (!tokens.isEmpty()) {
                peek = tokens.peek();
                if (plugin.hasCommand(peek, this.shell)) {
                    CommandMetadata command = plugin.getCommand(tokens.remove());
                    state.setCommand(command);
                } else if (this.couldBeCommand(plugin, peek)) {
                    state.setIndex(state.getBuffer().lastIndexOf(peek));
                    this.addCommandCandidates(plugin, state);
                }
            } else if (plugin.hasCommands()) {
                this.addCommandCandidates(plugin, state);
            }
            if (plugin.hasDefaultCommand()) {
                if (state.getCommand() == null) {
                    CommandMetadata defaultCommand = plugin.getDefaultCommand();
                    state.setCommand(defaultCommand);
                }
                if (tokens.isEmpty() && !state.hasSuggestions() && plugin.getDefaultCommand().equals(state.getCommand()) && plugin.hasCommands()) {
                    this.addCommandCandidates(plugin, state);
                }
            }
        }
    }

    private void addCommandCandidates(PluginMetadata plugin, PluginCommandCompleterState state) {
        Queue<String> tokens = state.getTokens();
        ArrayList<String> results = new ArrayList<String>();
        if (plugin.hasCommands()) {
            List commands = plugin.getCommands(this.shell);
            if (tokens.isEmpty()) {
                for (CommandMetadata command : commands) {
                    if (command.isDefault()) continue;
                    results.add(command.getName() + " ");
                }
            } else {
                String pluginBase = tokens.remove();
                for (CommandMetadata command : commands) {
                    if (command.isDefault() || !PluginCommandCompleter.isPotentialMatch(command.getName(), pluginBase)) continue;
                    results.add(command.getName() + " ");
                }
            }
        }
        state.getCandidates().addAll(results);
    }

    private boolean couldBeCommand(PluginMetadata plugin, String potentialCommand) {
        List commands = plugin.getCommands(this.shell);
        if (commands != null && !commands.isEmpty()) {
            for (CommandMetadata commandMetadata : commands) {
                if (commandMetadata.isDefault() || !PluginCommandCompleter.isPotentialMatch(commandMetadata.getName(), potentialCommand)) continue;
                return true;
            }
        }
        return false;
    }
}

