/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.Execution;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.PluginMetadata;
import org.jboss.forge.shell.command.PluginRegistry;
import org.jboss.forge.shell.command.PromptTypeConverter;
import org.jboss.forge.shell.command.parser.CommandParserContext;
import org.jboss.forge.shell.command.parser.CompositeCommandParser;
import org.jboss.forge.shell.command.parser.NamedBooleanOptionParser;
import org.jboss.forge.shell.command.parser.NamedValueOptionParser;
import org.jboss.forge.shell.command.parser.NamedValueVarargsOptionParser;
import org.jboss.forge.shell.command.parser.NullTokenOptionParser;
import org.jboss.forge.shell.command.parser.OrderedValueOptionParser;
import org.jboss.forge.shell.command.parser.OrderedValueVarargsOptionParser;
import org.jboss.forge.shell.exceptions.PluginExecutionException;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.util.Enums;
import org.jboss.forge.shell.util.GeneralUtils;
import org.jboss.forge.shell.util.Packages;
import org.mvel2.util.ParseTools;

public class ExecutionParser {
    private final PluginRegistry registry;
    private final Instance<Execution> executionInstance;
    private final Shell shell;
    private final PromptTypeConverter promptTypeConverter;

    @Inject
    public ExecutionParser(PluginRegistry registry, Instance<Execution> executionInstance, Shell shell, PromptTypeConverter promptTypeConverter) {
        this.registry = registry;
        this.executionInstance = executionInstance;
        this.shell = shell;
        this.promptTypeConverter = promptTypeConverter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Execution parse(Queue<String> tokens, String pipeIn, PipeOut pipeOut) {
        Execution execution = (Execution)this.executionInstance.get();
        CommandMetadata command = null;
        if (tokens.isEmpty()) return execution;
        String first = tokens.remove();
        execution.setOriginalStatement(first);
        PluginMetadata plugin = this.registry.getPluginMetadataForScopeAndConstraints(first, this.shell);
        if (plugin != null) {
            if (!tokens.isEmpty()) {
                String second = tokens.peek();
                command = plugin.getCommand(second, this.shell);
                if (command != null) {
                    if (!command.isDefault()) {
                        tokens.remove();
                    }
                } else if (plugin.hasDefaultCommand()) {
                    command = plugin.getDefaultCommand();
                }
            } else if (plugin.hasDefaultCommand()) {
                command = plugin.getDefaultCommand();
            }
            if (command == null) throw new PluginExecutionException(plugin, "Missing command for plugin [" + plugin.getName() + "], available commands: " + plugin.getCommands(this.shell));
            if (!command.usableWithResource(this.shell.getCurrentResource().getClass())) {
                throw new PluginExecutionException(plugin, "command '" + command.getName() + "' is not usable in current scope [" + this.shell.getCurrentResource().getClass().getSimpleName() + "]" + " -- usable scopes: " + GeneralUtils.elementSetSimpleTypesToString(command.getResourceScopes()));
            }
            execution.setCommand(command);
            Object[] parameters = this.parseParameters(command, tokens, pipeIn, pipeOut);
            execution.setParameterArray(parameters);
            return execution;
        } else {
            List pluginMetadata = this.registry.getPluginMetadata(first);
            if (pluginMetadata == null || pluginMetadata.isEmpty()) return execution;
            HashSet aggregate = new HashSet();
            for (PluginMetadata meta : pluginMetadata) {
                Set scopes = meta.getResourceScopes();
                aggregate.addAll(scopes);
            }
            throw new PluginExecutionException((PluginMetadata)pluginMetadata.get(0), "Plugin is not usable in current scope or project.");
        }
    }

    private Object[] parseParameters(CommandMetadata command, Queue<String> tokens, final String pipeIn, PipeOut pipeOut) {
        CompositeCommandParser commandParser = new CompositeCommandParser(new NamedBooleanOptionParser(), new NamedValueOptionParser(), new NamedValueVarargsOptionParser(), new OrderedValueOptionParser(), new OrderedValueVarargsOptionParser(), new NullTokenOptionParser());
        CommandParserContext context = new CommandParserContext();
        Map<OptionMetadata, Object> valueMap = commandParser.parse(command, tokens, context).getValueMap();
        for (String warning : context.getWarnings()) {
            ShellMessages.info((ShellPrintWriter)this.shell, (String)warning);
        }
        Object[] parameters = new Object[command.getOptions().size()];
        for (OptionMetadata option : command.getOptions()) {
            Object value;
            PromptType promptType = option.getPromptType();
            String defaultValue = option.getDefaultValue();
            Class optionType = option.getBoxedType();
            String optionDescriptor = option.getOptionDescriptor() + ": ";
            if (option.isPipeOut()) {
                value = pipeOut;
            } else if (option.isPipeIn()) {
                value = pipeIn;
                if (pipeIn != null && InputStream.class.isAssignableFrom(option.getBoxedType())) {
                    value = new InputStream(){
                        int cursor = 0;
                        int len = pipeIn.length();

                        @Override
                        public int read() throws IOException {
                            return this.cursor != this.len ? (int)pipeIn.charAt(this.cursor++) : -1;
                        }
                    };
                }
            } else {
                value = valueMap.get(option);
            }
            if (!option.isPipeOut() && !option.isPipeIn()) {
                if ((value = this.doPromptTypeConversions(value, promptType)) != null && option.getBoxedType().isEnum() && !Enums.hasValue(option.getType(), value)) {
                    ShellMessages.info((ShellPrintWriter)this.shell, (String)("Could not parse [" + value + "]... please try again..."));
                    value = !option.hasCustomCompleter() ? this.shell.promptEnum(optionDescriptor, option.getType()) : this.shell.promptCompleter(optionDescriptor, option.getCompleterType());
                } else if (value != null && promptType != null && !promptType.matches(value.toString())) {
                    ShellMessages.info((ShellPrintWriter)this.shell, (String)("Could not parse [" + value + "]... please try again..."));
                    if (promptType.equals((Object)PromptType.JAVA_PACKAGE)) {
                        String defaultPackage = value == null ? "" : Packages.toValidPackageName((String)((String)value));
                        value = this.shell.promptCommon(optionDescriptor, promptType, defaultPackage);
                    } else {
                        value = this.shell.promptCommon(optionDescriptor, promptType);
                    }
                } else if (option.isRequired() && value == null && !option.hasDefaultValue()) {
                    while (value == null) {
                        value = option.isEnum() ? this.shell.promptEnum(optionDescriptor, option.getType()) : (ExecutionParser.isBooleanOption(option) ? Boolean.valueOf(this.shell.promptBoolean(optionDescriptor)) : (this.isFileOption(optionType) ? this.shell.promptFile(optionDescriptor) : (promptType != null && !PromptType.ANY.equals((Object)promptType) ? this.shell.promptCommon(optionDescriptor, promptType) : this.shell.prompt(optionDescriptor))));
                        if (String.valueOf(value).trim().length() != 0) continue;
                        ShellMessages.info((ShellPrintWriter)this.shell, (String)"The option is required to execute this command.");
                        value = null;
                    }
                } else if (value == null && option.hasDefaultValue()) {
                    value = defaultValue;
                }
            }
            parameters[option.getIndex()] = value;
        }
        return parameters;
    }

    private Object doPromptTypeConversions(Object value, PromptType promptType) {
        if (value != null && value.getClass().isArray()) {
            Object[] values = value;
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.promptTypeConverter.convert(promptType, (String)values[i]);
            }
            value = values;
        } else {
            value = this.promptTypeConverter.convert(promptType, (String)value);
        }
        return value;
    }

    public boolean isFileOption(Class<?> optionType) {
        return File.class.isAssignableFrom(optionType);
    }

    private static boolean isBooleanOption(OptionMetadata option) {
        return ParseTools.unboxPrimitive((Class)option.getType()) == Boolean.TYPE;
    }
}

