/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.AnnotationTarget;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.java.Type;
import org.jboss.forge.parser.java.Visibility;
import org.jboss.forge.parser.java.VisibilityScoped;
import org.jboss.forge.parser.java.ast.AnnotationAccessor;
import org.jboss.forge.parser.java.ast.ModifierAccessor;
import org.jboss.forge.parser.java.impl.ParameterImpl;
import org.jboss.forge.parser.java.impl.TypeImpl;
import org.jboss.forge.parser.java.util.Types;

public class MethodImpl<O extends JavaSource<O>>
implements Method<O> {
    private final AnnotationAccessor<O, Method<O>> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private O parent = null;
    private AST ast = null;
    private CompilationUnit cu = null;
    private final MethodDeclaration method;

    private void init(O parent) {
        this.parent = parent;
        this.cu = (CompilationUnit)parent.getInternal();
        this.ast = this.cu.getAST();
    }

    public MethodImpl(O parent) {
        this.init(parent);
        this.method = this.ast.newMethodDeclaration();
        this.method.setConstructor(false);
    }

    public MethodImpl(O parent, Object internal) {
        this.init(parent);
        this.method = (MethodDeclaration)internal;
    }

    public MethodImpl(O parent, String method) {
        MethodDeclaration subtree;
        this.init(parent);
        String stub = "public class Stub { " + method + " }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        List methods = temp.getMethods();
        MethodDeclaration newMethod = (MethodDeclaration)((Method)methods.get(0)).getInternal();
        this.method = subtree = (MethodDeclaration)ASTNode.copySubtree((AST)this.cu.getAST(), (ASTNode)newMethod);
    }

    public String toSignature() {
        String signature = (Visibility.PACKAGE_PRIVATE.equals((Object)this.getVisibility().scope()) ? "" : this.getVisibility().scope()) + " ";
        signature = signature + this.getName() + "(";
        List<Parameter> parameters = this.getParameters();
        for (Parameter p : parameters) {
            signature = signature + p.getType();
            if (parameters.indexOf(p) >= parameters.size() - 1) continue;
            signature = signature + ", ";
        }
        signature = signature + ") : " + (this.getReturnType() == null ? "void" : this.getReturnType());
        return signature;
    }

    public Annotation<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTarget<O, Method<O>>)this, (BodyDeclaration)this.method);
    }

    public Annotation<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        if (!this.parent.hasImport(clazz)) {
            this.parent.addImport(clazz);
        }
        return this.annotations.addAnnotation((AnnotationTarget<O, Method<O>>)this, (BodyDeclaration)this.method, clazz.getSimpleName());
    }

    public Annotation<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTarget<O, Method<O>>)this, (BodyDeclaration)this.method, className);
    }

    public List<Annotation<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTarget<O, Method<O>>)this, (BodyDeclaration)this.method);
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, (BodyDeclaration)this.method, type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, (BodyDeclaration)this.method, type);
    }

    public Method<O> removeAnnotation(Annotation<O> annotation) {
        return this.annotations.removeAnnotation(this, (BodyDeclaration)this.method, annotation);
    }

    public Annotation<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTarget<O, Method<O>>)this, (BodyDeclaration)this.method, (Class<java.lang.annotation.Annotation>)type);
    }

    public Annotation<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTarget<O, Method<O>>)this, (BodyDeclaration)this.method, type);
    }

    public String getBody() {
        String result = "";
        List statements = (List)this.method.getBody().getStructuralProperty((StructuralPropertyDescriptor)Block.STATEMENTS_PROPERTY);
        for (Statement statement : statements) {
            result = result + statement + " ";
        }
        return result;
    }

    public Method<O> setBody(String body) {
        String stub = "public class Stub { public void method() {" + body + "} }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        List methods = temp.getMethods();
        Block block = ((MethodDeclaration)((Method)methods.get(0)).getInternal()).getBody();
        block = (Block)ASTNode.copySubtree((AST)this.method.getAST(), (ASTNode)block);
        this.method.setBody(block);
        return this;
    }

    public Method<O> setConstructor(boolean constructor) {
        this.method.setConstructor(constructor);
        if (this.isConstructor()) {
            this.method.setName(this.ast.newSimpleName(this.parent.getName()));
        }
        return this;
    }

    public boolean isConstructor() {
        return this.method.isConstructor();
    }

    public String getReturnType() {
        return Types.toSimpleName((String)this.getQualifiedReturnType());
    }

    public String getQualifiedReturnType() {
        String result = null;
        org.eclipse.jdt.core.dom.Type returnType = this.method.getReturnType2();
        if (returnType != null) {
            if ("void".equals(returnType.toString())) {
                return null;
            }
            if (!this.isConstructor()) {
                result = returnType.toString();
            }
        }
        result = this.parent.resolveType(result);
        return result;
    }

    public Type<O> getReturnTypeInspector() {
        return new TypeImpl<O>(this.parent, this.method.getReturnType2());
    }

    public Method<O> setReturnType(Class<?> type) {
        return this.setReturnType(type.getSimpleName());
    }

    public Method<O> setReturnType(String typeName) {
        String stub = "public class Stub { public " + typeName + " method() {} }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        List methods = temp.getMethods();
        org.eclipse.jdt.core.dom.Type returnType = ((MethodDeclaration)((Method)methods.get(0)).getInternal()).getReturnType2();
        returnType = (org.eclipse.jdt.core.dom.Type)ASTNode.copySubtree((AST)this.method.getAST(), (ASTNode)returnType);
        this.method.setReturnType2(returnType);
        return this;
    }

    public Method<O> setReturnType(JavaSource<?> type) {
        return this.setReturnType(type.getName());
    }

    public boolean isReturnTypeVoid() {
        return this.getReturnType() == null;
    }

    public Method<O> setReturnTypeVoid() {
        this.method.setReturnType2(null);
        return this;
    }

    public boolean isAbstract() {
        return this.modifiers.hasModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
    }

    public Method<O> setAbstract(boolean abstrct) {
        if (abstrct) {
            this.modifiers.addModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        } else {
            this.modifiers.removeModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.ABSTRACT_KEYWORD);
        }
        return this;
    }

    public boolean isFinal() {
        return this.modifiers.hasModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.FINAL_KEYWORD);
    }

    public Method<O> setFinal(boolean finl) {
        if (finl) {
            this.modifiers.addModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.FINAL_KEYWORD);
        } else {
            this.modifiers.removeModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.FINAL_KEYWORD);
        }
        return this;
    }

    public boolean isStatic() {
        return this.modifiers.hasModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.STATIC_KEYWORD);
    }

    public Method<O> setStatic(boolean statc) {
        if (statc) {
            this.modifiers.addModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.STATIC_KEYWORD);
        } else {
            this.modifiers.removeModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.STATIC_KEYWORD);
        }
        return this;
    }

    public String getName() {
        return this.method.getName().getFullyQualifiedName();
    }

    public Method<O> setName(String name) {
        if (this.method.isConstructor()) {
            throw new IllegalStateException("Cannot set the name of a constructor.");
        }
        this.method.setName(this.ast.newSimpleName(name));
        return this;
    }

    public Method<O> setParameters(String parameters) {
        String stub = "public class Stub { public void method( " + parameters + " ) {} }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        List methods = temp.getMethods();
        List astParameters = ((MethodDeclaration)((Method)methods.get(0)).getInternal()).parameters();
        this.method.parameters().clear();
        for (VariableDeclaration declaration : astParameters) {
            VariableDeclaration copy = (VariableDeclaration)ASTNode.copySubtree((AST)this.method.getAST(), (ASTNode)declaration);
            this.method.parameters().add(copy);
        }
        return this;
    }

    public List<Parameter> getParameters() {
        ArrayList<Parameter> results = new ArrayList<Parameter>();
        List parameters = this.method.parameters();
        for (VariableDeclaration param : parameters) {
            results.add(new ParameterImpl((JavaSource<?>)this.parent, param));
        }
        return results;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public Method<O> setPackagePrivate() {
        this.modifiers.clearVisibility((BodyDeclaration)this.method);
        return this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public Method<O> setPublic() {
        this.modifiers.clearVisibility((BodyDeclaration)this.method);
        this.modifiers.addModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public Method<O> setPrivate() {
        this.modifiers.clearVisibility((BodyDeclaration)this.method);
        this.modifiers.addModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public Method<O> setProtected() {
        this.modifiers.clearVisibility((BodyDeclaration)this.method);
        this.modifiers.addModifier((BodyDeclaration)this.method, Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public Method<O> setVisibility(Visibility scope) {
        return (Method)Visibility.set((VisibilityScoped)this, (Visibility)scope);
    }

    public String toString() {
        return this.method.toString();
    }

    public Object getInternal() {
        return this.method;
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodImpl other = (MethodImpl)obj;
        return !(this.method == null ? other.method != null : !this.method.equals((Object)other.method));
    }

    public Method<O> addThrows(Class<? extends Exception> type) {
        return this.addThrows(type.getName());
    }

    public Method<O> addThrows(String type) {
        String packg = Types.getPackage((String)type);
        String name = Types.toSimpleName((String)type);
        if (!packg.isEmpty()) {
            this.getOrigin().addImport(type);
        }
        SimpleName simpleName = this.method.getAST().newSimpleName(name);
        List list = (List)this.method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
        list.add(simpleName);
        return this;
    }

    public List<String> getThrownExceptions() {
        ArrayList<String> result = new ArrayList<String>();
        List list = (List)this.method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
        for (Object object : list) {
            result.add(object.toString());
        }
        return result;
    }

    public Method<O> removeThrows(Class<? extends Exception> type) {
        return this.removeThrows(type.getName());
    }

    public Method<O> removeThrows(String type) {
        List list = (List)this.method.getStructuralProperty((StructuralPropertyDescriptor)MethodDeclaration.THROWN_EXCEPTIONS_PROPERTY);
        for (Object object : list) {
            String thrown = object.toString();
            if (type.equals(thrown)) {
                list.remove(object);
                return this;
            }
            if (!Types.areEquivalent((String)type, (String)thrown)) continue;
            if (!Types.isQualified((String)type) && this.getOrigin().hasImport(thrown)) {
                list.remove(object);
                return this;
            }
            if (!Types.isQualified((String)thrown) && this.getOrigin().hasImport(type)) {
                list.remove(object);
                return this;
            }
            if (this.getOrigin().hasImport(type) || this.getOrigin().hasImport(thrown)) continue;
            list.remove(object);
            return this;
        }
        return this;
    }
}

