/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.AnnotationTarget;
import org.jboss.forge.parser.java.JavaClass;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.ValuePair;
import org.jboss.forge.parser.java.impl.ValuePairImpl;
import org.jboss.forge.parser.java.util.Strings;

public class AnnotationImpl<O extends JavaSource<O>, T>
implements Annotation<O> {
    private static final String DEFAULT_VALUE = "value";
    private AnnotationTarget<O, T> parent = null;
    private AST ast = null;
    private org.eclipse.jdt.core.dom.Annotation annotation;

    private void init(AnnotationTarget<O, T> parent) {
        this.parent = parent;
        this.ast = ((ASTNode)parent.getInternal()).getAST();
    }

    public AnnotationImpl(AnnotationTarget<O, T> parent) {
        this(parent, AnnotationType.MARKER);
    }

    public AnnotationImpl(AnnotationTarget<O, T> parent, Object internal) {
        this.init(parent);
        this.annotation = (org.eclipse.jdt.core.dom.Annotation)internal;
    }

    public AnnotationImpl(AnnotationTarget<O, T> parent, AnnotationType type) {
        this.init(parent);
        switch (type) {
            case MARKER: {
                this.annotation = this.ast.newMarkerAnnotation();
                break;
            }
            case SINGLE: {
                this.annotation = this.ast.newSingleMemberAnnotation();
                break;
            }
            case NORMAL: {
                this.annotation = this.ast.newNormalAnnotation();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown annotation type: " + (Object)((Object)type));
            }
        }
    }

    public String getName() {
        return this.annotation.getTypeName().getFullyQualifiedName();
    }

    public String getQualifiedName() {
        return ((JavaSource)this.parent.getOrigin()).resolveType(this.getName());
    }

    public String getLiteralValue() throws IllegalStateException {
        String result = null;
        if (this.isSingleValue()) {
            SingleMemberAnnotation sm = (SingleMemberAnnotation)this.annotation;
            result = sm.getValue().toString();
        } else if (this.isNormal()) {
            List<ValuePair> values = this.getValues();
            for (ValuePair pair : values) {
                String name = pair.getName();
                if (!DEFAULT_VALUE.equals(name)) continue;
                result = pair.getLiteralValue();
                break;
            }
        }
        return result;
    }

    public String getLiteralValue(String name) {
        String result = null;
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                MemberValuePair pair;
                if (!(v instanceof MemberValuePair) || !(pair = (MemberValuePair)v).getName().getFullyQualifiedName().equals(name)) continue;
                result = pair.getValue().toString();
                break;
            }
        } else if (DEFAULT_VALUE.equals(name) && this.isSingleValue()) {
            return this.getLiteralValue();
        }
        return result;
    }

    public List<ValuePair> getValues() {
        ArrayList<ValuePairImpl> result = new ArrayList<ValuePairImpl>();
        if (this.isNormal()) {
            for (Object v : ((NormalAnnotation)this.annotation).values()) {
                if (!(v instanceof MemberValuePair)) continue;
                MemberValuePair pair = (MemberValuePair)v;
                ValuePairImpl temp = new ValuePairImpl(pair.getName().getFullyQualifiedName(), pair.getValue().toString());
                result.add(temp);
            }
        } else if (this.isSingleValue()) {
            result.add(new ValuePairImpl(DEFAULT_VALUE, this.getLiteralValue()));
        }
        return Collections.unmodifiableList(result);
    }

    public String getStringValue() throws IllegalStateException {
        return Strings.unquote((String)this.getLiteralValue());
    }

    public String getStringValue(String name) {
        return Strings.unquote((String)this.getLiteralValue(name));
    }

    public boolean isMarker() {
        return this.annotation.isMarkerAnnotation();
    }

    public boolean isNormal() {
        return this.annotation.isNormalAnnotation();
    }

    public boolean isSingleValue() {
        return this.annotation.isSingleMemberAnnotation();
    }

    public Annotation<O> removeAllValues() {
        this.convertTo(AnnotationType.MARKER);
        return this;
    }

    public Annotation<O> removeValue(String name) {
        if (this.annotation.isNormalAnnotation()) {
            NormalAnnotation na = (NormalAnnotation)this.annotation;
            ArrayList<MemberValuePair> toBeRemoved = new ArrayList<MemberValuePair>();
            for (Object v : na.values()) {
                MemberValuePair pair;
                if (!(v instanceof MemberValuePair) || !(pair = (MemberValuePair)v).getName().toString().equals(name)) continue;
                toBeRemoved.add(pair);
            }
            na.values().removeAll(toBeRemoved);
            if (this.getLiteralValue() != null && this.getValues().size() == 1) {
                this.convertTo(AnnotationType.SINGLE);
            } else if (this.getValues().size() == 0) {
                this.convertTo(AnnotationType.MARKER);
            }
        } else if (this.annotation.isSingleMemberAnnotation()) {
            this.removeAllValues();
        }
        return this;
    }

    public Annotation<O> setName(String className) {
        this.annotation.setTypeName(this.ast.newName(className));
        return this;
    }

    public Annotation<O> setLiteralValue(String value) {
        if (this.isMarker()) {
            this.convertTo(AnnotationType.SINGLE);
        }
        if (this.isSingleValue()) {
            SingleMemberAnnotation sa = (SingleMemberAnnotation)this.annotation;
            String stub = "@" + this.getName() + "(" + value + ") public class Stub { }";
            JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
            SingleMemberAnnotation anno = (SingleMemberAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
            Expression expression = anno.getValue();
            sa.setValue((Expression)ASTNode.copySubtree((AST)this.ast, (ASTNode)expression));
        } else {
            this.setLiteralValue(DEFAULT_VALUE, value);
        }
        return this;
    }

    public Annotation<O> setLiteralValue(String name, String value) {
        if (!this.isNormal() && !DEFAULT_VALUE.equals(name)) {
            this.convertTo(AnnotationType.NORMAL);
        } else if (!this.isSingleValue() && !this.isNormal() && DEFAULT_VALUE.equals(name)) {
            this.convertTo(AnnotationType.SINGLE);
            return this.setLiteralValue(value);
        }
        NormalAnnotation na = (NormalAnnotation)this.annotation;
        String stub = "@" + this.getName() + "(" + name + "=" + value + " ) public class Stub { }";
        JavaClass temp = (JavaClass)JavaParser.parse((String)stub);
        NormalAnnotation anno = (NormalAnnotation)((Annotation)temp.getAnnotations().get(0)).getInternal();
        for (Object v : anno.values()) {
            if (!(v instanceof MemberValuePair)) continue;
            na.values().add(ASTNode.copySubtree((AST)this.annotation.getAST(), (ASTNode)((MemberValuePair)v)));
        }
        return this;
    }

    public Annotation<O> setStringValue(String value) {
        return this.setLiteralValue(Strings.enquote((String)value));
    }

    public Annotation<O> setStringValue(String name, String value) {
        return this.setLiteralValue(name, Strings.enquote((String)value));
    }

    public <E extends Enum<E>> E getEnumValue(Class<E> type) {
        String literalValue = this.getLiteralValue();
        return this.convertLiteralToEnum(type, literalValue);
    }

    public <E extends Enum<E>> E getEnumValue(Class<E> type, String name) {
        String literalValue = this.getLiteralValue(name);
        return this.convertLiteralToEnum(type, literalValue);
    }

    private <E extends Enum<E>> E convertLiteralToEnum(Class<E> type, String literalValue) {
        Enum[] constants;
        for (Enum inst : constants = (Enum[])type.getEnumConstants()) {
            String[] tokens = literalValue.split("\\.");
            if (tokens.length > 1) {
                literalValue = tokens[tokens.length - 1];
            }
            if (!inst.name().equals(literalValue)) continue;
            return (E)inst;
        }
        return null;
    }

    public Annotation<O> setEnumValue(String name, Enum<?> value) {
        O source;
        O origin = this.getOrigin();
        if (origin instanceof JavaSource && !(source = origin).hasImport(value.getDeclaringClass())) {
            source.addImport(value.getDeclaringClass());
        }
        return this.setLiteralValue(name, value.getDeclaringClass().getSimpleName() + "." + value.name());
    }

    public Annotation<O> setEnumValue(Enum<?> ... values) {
        O origin = this.getOrigin();
        String result = new String();
        if (values.length > 1) {
            result = "{";
        }
        if (origin instanceof JavaSource) {
            O source = origin;
            for (Enum<?> value : values) {
                if (!source.hasImport(value.getDeclaringClass())) {
                    source.addImport(value.getDeclaringClass());
                }
                result = result.concat(value.getDeclaringClass().getSimpleName() + "." + value.name() + ",");
            }
            result = result.substring(0, result.length() - 1);
            if (values.length > 1) {
                result = result.concat("}");
            }
        }
        return this.setLiteralValue(result);
    }

    public O getOrigin() {
        return (O)((JavaSource)this.parent.getOrigin());
    }

    public Object getInternal() {
        return this.annotation;
    }

    public String toString() {
        return this.annotation.toString();
    }

    private void convertTo(AnnotationType type) {
        BodyDeclaration node = (BodyDeclaration)this.annotation.getParent();
        String value = this.getLiteralValue();
        for (Object o : node.modifiers()) {
            if (!o.equals(this.annotation)) continue;
            node.modifiers().remove(this.annotation);
            AnnotationImpl<O, T> na = new AnnotationImpl<O, T>(this.parent, type);
            na.setName(this.getName());
            this.annotation = (org.eclipse.jdt.core.dom.Annotation)na.getInternal();
            node.modifiers().add(this.annotation);
            break;
        }
        if (!AnnotationType.MARKER.equals((Object)type) && value != null) {
            this.setLiteralValue(value);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotation == null ? 0 : this.annotation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationImpl other = (AnnotationImpl)obj;
        return !(this.annotation == null ? other.annotation != null : !this.annotation.equals((Object)other.annotation));
    }

    private static enum AnnotationType {
        MARKER,
        SINGLE,
        NORMAL;

    }
}

